/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.reporting;

import io.rainfall.Reporter;
import io.rainfall.reporting.GcStatsCollector;
import io.rainfall.statistics.StatisticsHolder;
import io.rainfall.statistics.StatisticsPeek;
import io.rainfall.statistics.StatisticsPeekHolder;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.TimeZone;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.HdrHistogram.Histogram;

public class HtmlReporter<E extends Enum<E>>
extends Reporter<E> {
    private String basedir;
    private String averageLatencyFile = "averageLatency.csv";
    private String tpsFile = "tps.csv";
    private String percentilesFile = "total-percentiles.csv";
    private String gcFile = "gc.csv";
    private String reportFile;
    private final File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
    private static final String CRLF = System.getProperty("line.separator");
    private Calendar calendar = GregorianCalendar.getInstance(TimeZone.getDefault());
    private SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
    private final GcStatsCollector gcStatsCollector = new GcStatsCollector();
    private static final int[] illegalChars = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47, 64, 46, 39, 34, 33, 35, 36, 37, 94, 38, 42, 40, 41, 92};

    public HtmlReporter() {
        this("target/rainfall-report");
    }

    public HtmlReporter(String outputPath) {
        try {
            this.basedir = new File(outputPath).getAbsoluteFile().getAbsolutePath();
            this.reportFile = this.basedir + File.separatorChar + "report.html";
            this.deleteDirectory(new File(this.basedir));
            if (this.jarFile.isFile()) {
                this.extractFromJar("/report", this.basedir);
            } else {
                this.extractFromPath(new File(HtmlReporter.class.getClass().getResource("/report").toURI()), new File(this.basedir));
            }
            this.gcStatsCollector.registerGcEventListeners();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can not read report template");
        }
        catch (IOException e) {
            throw new RuntimeException("Can not copy report template");
        }
    }

    private void extractFromPath(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            dst.mkdirs();
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dst, file);
                this.extractFromPath(srcFile, destFile);
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    @Override
    public void report(StatisticsPeekHolder<E> statisticsPeekHolder) {
        try {
            if (!new File(this.reportFile).exists()) {
                this.copyReportTemplate(statisticsPeekHolder);
            }
            StatisticsPeek<E> totalStatisticsPeeks = statisticsPeekHolder.getTotalStatisticsPeeks();
            Set<String> keys = statisticsPeekHolder.getStatisticsPeeksNames();
            for (String key : keys) {
                StatisticsPeek<E> statisticsPeeks = statisticsPeekHolder.getStatisticsPeeks(key);
                this.logPeriodicStats(key, statisticsPeeks, statisticsPeekHolder.getResultsReported());
            }
            if (totalStatisticsPeeks != null) {
                this.logPeriodicStats("total", totalStatisticsPeeks, statisticsPeekHolder.getResultsReported());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can not write report data");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can not write report data");
        }
    }

    @Override
    public void summarize(StatisticsHolder<E> statisticsHolder) {
        try {
            Enum<E>[] results;
            if (!new File(this.reportFile).exists()) {
                this.copyReportTemplate(statisticsHolder);
            }
            this.gcStatsCollector.unregisterGcEventListeners();
            StringBuilder sb = new StringBuilder();
            for (Enum<E> result : results = statisticsHolder.getResultsReported()) {
                Histogram histogram = statisticsHolder.getHistogramSink(result).fetchHistogram();
                try {
                    histogram = histogram.copyCorrectedForCoordinatedOmission(1000000L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                String percentilesFilename = this.basedir + File.separatorChar + this.getPercentilesFilename(result.name());
                PrintStream stream = new PrintStream(new File(percentilesFilename));
                try {
                    histogram.outputPercentileDistribution(stream, 5, Double.valueOf(1000000.0), true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                stream.close();
                String mean = "NaN";
                try {
                    mean = "" + histogram.getMean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String maxValue = "NaN";
                try {
                    maxValue = "" + histogram.getMaxValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sb.append("reportPercentiles('").append(this.getPercentilesFilename(result.name()).substring(0, this.getPercentilesFilename(result.name()).length() - 4)).append("', 'Reponse Time percentiles for ").append(result.name()).append("', '" + mean + "', '" + maxValue).append("');").append(CRLF);
            }
            this.substituteInFile(new FileInputStream(new File(this.reportFile)), this.reportFile, "//!summary!", sb);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not report to Html", e);
        }
    }

    private void logPeriodicStats(String name, StatisticsPeek<E> statisticsPeek, Enum<E>[] resultsReported) throws IOException {
        String avgFilename = this.basedir + File.separatorChar + this.getAverageLatencyFilename(name);
        String tpsFilename = this.basedir + File.separatorChar + this.getTpsFilename(name);
        String gcFilename = this.basedir + File.separatorChar + this.getGcFilename();
        BufferedWriter averageLatencyOutput = new BufferedWriter(new FileWriter(avgFilename, true));
        if (new File(avgFilename).length() == 0L) {
            this.addHeader(averageLatencyOutput, resultsReported);
        }
        BufferedWriter tpsOutput = new BufferedWriter(new FileWriter(tpsFilename, true));
        if (new File(tpsFilename).length() == 0L) {
            this.addHeader(tpsOutput, resultsReported);
        }
        BufferedWriter gcOutput = new BufferedWriter(new FileWriter(gcFilename, true));
        if (new File(gcFilename).length() == 0L) {
            this.addHeader(gcOutput, GcStatsCollector.GcStats.Header.values());
        }
        String timestamp = this.formatTimestampInNano(statisticsPeek.getTimestamp());
        StringBuilder averageLatencySb = new StringBuilder(timestamp);
        StringBuilder tpsSb = new StringBuilder(timestamp);
        for (Enum<E> result : resultsReported) {
            averageLatencySb.append(",").append(String.format("%.4f", statisticsPeek.getPeriodicAverageLatencyInMs(result)));
            tpsSb.append(",").append(statisticsPeek.getPeriodicTps(result));
        }
        averageLatencyOutput.append(averageLatencySb.toString()).append("\n");
        tpsOutput.append(tpsSb.toString()).append("\n");
        List<GcStatsCollector.GcStats> gcStatsList = this.gcStatsCollector.drain();
        for (GcStatsCollector.GcStats gcStats : gcStatsList) {
            gcOutput.append(this.toCsv(gcStats)).append("\n");
        }
        ((Writer)averageLatencyOutput).close();
        ((Writer)tpsOutput).close();
        ((Writer)gcOutput).close();
    }

    private String toCsv(GcStatsCollector.GcStats gcStats) {
        long jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        return String.valueOf(this.formatTimestampInNano(jvmStartTime + gcStats.getStartTimestamp())) + "," + gcStats.getDuration() + "," + gcStats.getAction() + "," + gcStats.getCause() + "," + gcStats.getName();
    }

    public void extractFromJar(String sourceDirectory, String writeDirectory) throws IOException {
        URL dirURL = this.getClass().getResource(sourceDirectory);
        String path = sourceDirectory.substring(1);
        if (dirURL != null && dirURL.getProtocol().equals("jar")) {
            JarURLConnection jarConnection = (JarURLConnection)dirURL.openConnection();
            System.out.println("jarConnection is " + jarConnection);
            JarFile jar = jarConnection.getJarFile();
            Enumeration<? extends ZipEntry> entries = ((ZipFile)jar).entries();
            while (entries.hasMoreElements()) {
                int readCount;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path)) continue;
                String entryTail = name.substring(path.length());
                File f = new File(writeDirectory + File.separator + entryTail);
                if (entry.isDirectory()) {
                    boolean bMade = f.mkdirs();
                    System.out.println((bMade ? "  creating " : "  unable to create ") + f.getCanonicalPath());
                    continue;
                }
                System.out.println("  writing  " + f.getCanonicalPath());
                InputStream is = ((ZipFile)jar).getInputStream(entry);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                byte[] buffer = new byte[4096];
                while ((readCount = is.read(buffer)) > 0) {
                    ((OutputStream)os).write(buffer, 0, readCount);
                }
                ((OutputStream)os).close();
                is.close();
            }
        } else {
            if (dirURL == null) {
                throw new IllegalStateException("can't find " + sourceDirectory + " on the classpath");
            }
            throw new IllegalStateException("don't know how to handle extracting from " + dirURL);
        }
    }

    private String getTpsFilename(String key) {
        return this.cleanFilename(key) + "-" + this.tpsFile;
    }

    private String getAverageLatencyFilename(String key) {
        return this.cleanFilename(key) + "-" + this.averageLatencyFile;
    }

    private String getPercentilesFilename(String result) {
        return this.cleanFilename(result) + "-" + this.percentilesFile;
    }

    private String getGcFilename() {
        return this.gcFile;
    }

    public String cleanFilename(String filename) {
        Arrays.sort(illegalChars);
        StringBuilder cleanName = new StringBuilder();
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (Arrays.binarySearch(illegalChars, (int)c) >= 0) continue;
            cleanName.append(c);
        }
        return cleanName.toString();
    }

    private void copyReportTemplate(StatisticsHolder<E> peek) throws IOException, URISyntaxException {
        Set<String> names = peek.getStatisticsKeys();
        this.copyReport(names);
    }

    private void copyReportTemplate(StatisticsPeekHolder<E> peek) throws IOException, URISyntaxException {
        Set<String> names = peek.getStatisticsPeeksNames();
        this.copyReport(names);
    }

    private void copyReport(Set<String> names) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            String tpsFilename = this.getTpsFilename(name);
            sb.append("reportTps('").append(tpsFilename.substring(0, tpsFilename.length() - 4)).append("', 'Periodic TPS - ").append(name).append("');").append(CRLF);
        }
        sb.append("reportTps('total-tps', 'Periodic Total TPS');").append(CRLF);
        for (String key : names) {
            String averageLatencyFilename = this.getAverageLatencyFilename(key);
            sb.append("reportResponseTime('").append(averageLatencyFilename.substring(0, averageLatencyFilename.length() - 4)).append("', 'Periodic Reponse Time - ").append(key).append("');").append(CRLF);
        }
        sb.append("reportResponseTime('total-averageLatency', 'Periodic Average Response Time of all entities');").append(CRLF);
        sb.append("reportGc('gc', 'GC Time');").append(CRLF);
        InputStream in = HtmlReporter.class.getClass().getResourceAsStream("/template/Tps-template.html");
        this.substituteInFile(in, this.reportFile, "//!report!", sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void substituteInFile(InputStream in, String outputFile, String marker, StringBuilder sb) throws IOException {
        Scanner scanner = new Scanner(in);
        StringBuilder fileContents = new StringBuilder();
        try {
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine()).append(CRLF);
            }
        }
        finally {
            scanner.close();
        }
        in.close();
        byte[] replace = fileContents.toString().replace(marker, sb.toString()).getBytes();
        FileOutputStream out = new FileOutputStream(outputFile);
        ((OutputStream)out).write(replace, 0, replace.length);
        ((OutputStream)out).close();
    }

    private String formatTimestampInNano(long timestamp) {
        this.calendar.setTime(new Date(timestamp));
        return this.sdf.format(this.calendar.getTime());
    }

    private void addHeader(Writer output, Enum[] keys) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("timestamp");
        for (Enum key : keys) {
            sb.append(",").append(key.name());
        }
        output.append(sb.toString()).append("\n");
    }

    private void deleteDirectory(File path) {
        if (path == null) {
            return;
        }
        if (path.exists()) {
            for (File f : path.listFiles()) {
                if (f.isDirectory()) {
                    this.deleteDirectory(f);
                    f.delete();
                    continue;
                }
                f.delete();
            }
            path.delete();
        }
    }
}

