/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.reporting;

import io.rainfall.Reporter;
import io.rainfall.statistics.StatisticsHolder;
import io.rainfall.statistics.StatisticsPeek;
import io.rainfall.statistics.StatisticsPeekHolder;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TimeZone;
import org.HdrHistogram.Histogram;

public class TextReporter<E extends Enum<E>>
extends Reporter<E> {
    private static final String FORMAT = "%-15s %-15s %12s %10s %10s";
    private static final NumberFormat nf = NumberFormat.getInstance();
    private String CRLF = System.getProperty("line.separator");
    private Calendar calendar = GregorianCalendar.getInstance(TimeZone.getDefault());
    private SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");

    @Override
    public void report(StatisticsPeekHolder<E> statisticsHolder) {
        StatisticsPeek<E> statisticsPeeks;
        StringBuilder sb = new StringBuilder();
        StatisticsPeek<E> totalStatisticsPeeks = statisticsHolder.getTotalStatisticsPeeks();
        Set<String> keys = statisticsHolder.getStatisticsPeeksNames();
        sb.append("===================================================== PERIODIC ==========================================").append(this.CRLF);
        sb.append(String.format(FORMAT, "Cache", "Type", "Txn_Count", "TPS", "Avg_Lat")).append(this.CRLF);
        sb.append("==========================================================================================================").append(this.CRLF);
        for (String key : keys) {
            statisticsPeeks = statisticsHolder.getStatisticsPeeks(key);
            this.logPeriodicStats(sb, key, statisticsPeeks, statisticsHolder.getResultsReported());
        }
        if (totalStatisticsPeeks != null) {
            this.logPeriodicStats(sb, "ALL", totalStatisticsPeeks, statisticsHolder.getResultsReported());
        }
        sb.append("==================================================== CUMULATIVE =========================================").append(this.CRLF);
        sb.append(String.format(FORMAT, "Cache", "Type", "Txn_Count", "TPS", "Avg_Lat")).append(this.CRLF);
        sb.append("==========================================================================================================").append(this.CRLF);
        for (String key : keys) {
            statisticsPeeks = statisticsHolder.getStatisticsPeeks(key);
            this.logCumulativeStats(sb, key, statisticsPeeks, statisticsHolder.getResultsReported());
        }
        if (totalStatisticsPeeks != null) {
            this.logCumulativeStats(sb, "ALL", totalStatisticsPeeks, statisticsHolder.getResultsReported());
        }
        System.out.println(sb.toString());
    }

    @Override
    public void summarize(StatisticsHolder<E> statisticsHolder) {
        Enum<E>[] results;
        for (Enum<E> result : results = statisticsHolder.getResultsReported()) {
            System.out.println("Percentiles distribution for result : " + result);
            try {
                Histogram histogram = statisticsHolder.getHistogramSink(result).fetchHistogram();
                try {
                    histogram = histogram.copyCorrectedForCoordinatedOmission(1000L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                histogram.outputPercentileDistribution(System.out, 5, Double.valueOf(1000000.0), false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void logCumulativeStats(StringBuilder sb, String name, StatisticsPeek<E> peek, Enum<E>[] resultsReported) {
        sb.append(this.formatTimestampInMs(peek.getTimestamp())).append(this.CRLF);
        for (Enum<E> result : resultsReported) {
            sb.append(String.format(FORMAT, name, result.name(), nf.format(peek.getCumulativeCounters(result)), nf.format(peek.getCumulativeTps(result)), nf.format(peek.getCumulativeAverageLatencyInMs(result)))).append(this.CRLF);
        }
        sb.append(String.format(FORMAT, name, "TOTAL", nf.format(peek.getSumOfCumulativeCounters()), nf.format(peek.getSumOfCumulativeTps()), nf.format(peek.getAverageOfCumulativeAverageLatencies()))).append(this.CRLF);
    }

    private void logPeriodicStats(StringBuilder sb, String name, StatisticsPeek<E> peek, Enum<E>[] resultsReported) {
        sb.append(this.formatTimestampInMs(peek.getTimestamp())).append(this.CRLF);
        for (Enum<E> result : resultsReported) {
            sb.append(String.format(FORMAT, name, result.name(), nf.format(peek.getPeriodicCounters(result)), nf.format(peek.getPeriodicTps(result)), nf.format(peek.getPeriodicAverageLatencyInMs(result)))).append(this.CRLF);
        }
        sb.append(String.format(FORMAT, name, "TOTAL", nf.format(peek.getSumOfPeriodicCounters()), nf.format(peek.getSumOfPeriodicTps()), nf.format(peek.getAverageOfPeriodicAverageLatencies()))).append(this.CRLF);
    }

    private String formatTimestampInMs(long timestamp) {
        this.calendar.setTime(new Date(timestamp));
        return this.sdf.format(this.calendar.getTime());
    }
}

