/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;

public class RainfallHistogramSink {
    private final Factory factory;
    private final ConcurrentLinkedQueue<HistogramHolder> actives = new ConcurrentLinkedQueue();
    private static final ThreadLocal<HistogramHolder> context = new ThreadLocal();

    public RainfallHistogramSink(Factory factory) {
        this.factory = factory;
    }

    private HistogramHolder perThread() {
        HistogramHolder hh = context.get();
        if (hh == null || hh.isDead()) {
            hh = new HistogramHolder(this.factory.createHistogram());
            this.actives.add(hh);
            context.set(hh);
        }
        return hh;
    }

    public void recordValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.perThread().getHistogram().recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    public void recordValueWithCount(long value, long count) throws ArrayIndexOutOfBoundsException {
        this.perThread().getHistogram().recordValueWithCount(value, count);
    }

    public void recordValue(long value) throws ArrayIndexOutOfBoundsException {
        this.perThread().getHistogram().recordValue(value);
    }

    public Histogram fetchHistogram() {
        Histogram aggregate = this.factory.createHistogram();
        for (HistogramHolder hh : this.actives) {
            aggregate.add((AbstractHistogram)hh.getHistogram());
        }
        return aggregate;
    }

    public void reset() {
        for (HistogramHolder hh : this.actives) {
            hh.setDead(true);
            hh.getHistogram().reset();
        }
        this.actives.clear();
    }

    public static interface Factory {
        public Histogram createHistogram();
    }

    private static class HistogramHolder {
        private volatile boolean dead = false;
        private Histogram histogram;

        public HistogramHolder(Histogram histogram) {
            this.setHistogram(histogram);
        }

        public boolean isDead() {
            return this.dead;
        }

        public void setDead(boolean dead) {
            this.dead = dead;
        }

        public Histogram getHistogram() {
            return this.histogram;
        }

        public void setHistogram(Histogram histogram) {
            this.histogram = histogram;
        }
    }
}

