/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics;

import io.rainfall.statistics.RainfallHistogramSink;
import io.rainfall.statistics.Statistics;
import io.rainfall.statistics.StatisticsHolder;
import io.rainfall.statistics.StatisticsPeekHolder;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jsr166e.LongAdder;
import org.HdrHistogram.Histogram;

public class RuntimeStatisticsHolder<E extends Enum<E>>
implements StatisticsHolder<E> {
    private final ConcurrentHashMap<String, LongAdder> assertionsErrors = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Statistics<E>> statistics = new ConcurrentHashMap();
    private final ConcurrentHashMap<Enum, RainfallHistogramSink> histograms = new ConcurrentHashMap();
    private Enum<E>[] results;
    private Enum<E>[] resultsReported;

    public RuntimeStatisticsHolder(Enum<E>[] results, Enum<E>[] resultsReported) {
        this.results = results;
        this.resultsReported = resultsReported;
        for (Enum<E> result : results) {
            this.histograms.put(result, new RainfallHistogramSink(new RainfallHistogramSink.Factory(){

                @Override
                public Histogram createHistogram() {
                    return new Histogram(3);
                }
            }));
        }
    }

    public Enum<E>[] getResults() {
        return this.results;
    }

    @Override
    public Enum<E>[] getResultsReported() {
        return this.resultsReported;
    }

    @Override
    public Set<String> getStatisticsKeys() {
        return this.statistics.keySet();
    }

    @Override
    public Statistics<E> getStatistics(String name) {
        return this.statistics.get(name);
    }

    @Override
    public RainfallHistogramSink getHistogramSink(Enum<E> result) {
        return this.histograms.get(result);
    }

    public void addStatistics(String name, Statistics<E> statistics) {
        this.statistics.put(name, statistics);
        this.assertionsErrors.put(name, new LongAdder());
    }

    protected long getTimeInNs() {
        return System.nanoTime();
    }

    @Override
    public synchronized void reset() {
        for (Statistics<E> statistics : this.statistics.values()) {
            statistics.reset();
        }
        for (RainfallHistogramSink sink : this.histograms.values()) {
            sink.reset();
        }
        System.out.println("reset");
    }

    @Override
    public synchronized long getCurrentTps(Enum result) {
        long totalCounter = 0L;
        for (Statistics<E> statistics : this.statistics.values()) {
            totalCounter += statistics.getCurrentTps(result);
        }
        return totalCounter / (long)this.statistics.size();
    }

    @Override
    public void record(String name, long responseTimeInNs, Enum result) {
        this.statistics.get(name).increaseCounterAndSetLatencyInNs(result, responseTimeInNs);
        try {
            this.histograms.get(result).recordValue(responseTimeInNs);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void increaseAssertionsErrorsCount(String name) {
        this.assertionsErrors.get(name).increment();
    }

    public StatisticsPeekHolder<E> peek() {
        return new StatisticsPeekHolder<E>(this.resultsReported, this.statistics, this.assertionsErrors);
    }
}

