/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jsr166e.LongAdder;

public class StatisticsPeek<E extends Enum<E>> {
    private String name;
    private long timestamp;
    private final Map<Enum, Long> periodicCounters = new HashMap<Enum, Long>();
    private final Map<Enum, Double> periodicAverageLatencies = new HashMap<Enum, Double>();
    private final Map<Enum, Long> periodicTps = new HashMap<Enum, Long>();
    private Long sumOfPeriodicCounters = 0L;
    private double averageOfPeriodicAverageLatencies = 0.0;
    private Long sumOfPeriodicTps = 0L;
    private final Map<Enum, Long> cumulativeCounters = new HashMap<Enum, Long>();
    private final Map<Enum, Double> cumulativeAverageLatencies = new HashMap<Enum, Double>();
    private final Map<Enum, Long> cumulativeTps = new HashMap<Enum, Long>();
    private Long sumOfCumulativeCounters = 0L;
    private double averageOfCumulativeAverageLatencies = 0.0;
    private Long sumOfCumulativeTps = 0L;
    private Enum<E>[] keys;

    public StatisticsPeek(String name, Enum<E>[] keys, long timestamp) {
        this.name = name;
        this.keys = keys;
        this.timestamp = timestamp;
    }

    public String getName() {
        return this.name;
    }

    public Enum<E>[] getKeys() {
        return this.keys;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setCumulativeValues(long length, ConcurrentHashMap<Enum, LongAdder> cumulativeCounters, ConcurrentHashMap<Enum, LongAdder> cumulativeTotalLatencies) {
        long lengthInSec = length / 1000000L / 1000L;
        for (Enum<E> key : this.keys) {
            LongAdder cumulativeCounter = cumulativeCounters.get(key);
            this.cumulativeCounters.put(key, cumulativeCounter.longValue());
            LongAdder cumulativeTotalLatency = cumulativeTotalLatencies.get(key);
            this.cumulativeAverageLatencies.put(key, cumulativeTotalLatency.doubleValue() / cumulativeCounter.doubleValue() / 1000000.0);
            if (lengthInSec > 0L) {
                this.cumulativeTps.put(key, cumulativeCounter.longValue() / lengthInSec);
            } else {
                this.cumulativeTps.put(key, cumulativeCounter.longValue());
            }
            StatisticsPeek statisticsPeek = this;
            Long.valueOf(statisticsPeek.sumOfCumulativeCounters + cumulativeCounter.longValue());
            statisticsPeek.sumOfCumulativeCounters = statisticsPeek.sumOfCumulativeCounters;
            this.averageOfCumulativeAverageLatencies += cumulativeTotalLatency.doubleValue();
            statisticsPeek = this;
            Long.valueOf(statisticsPeek.sumOfCumulativeTps + this.cumulativeTps.get(key));
            statisticsPeek.sumOfCumulativeTps = statisticsPeek.sumOfCumulativeTps;
        }
        this.averageOfCumulativeAverageLatencies = this.averageOfCumulativeAverageLatencies / (double)this.sumOfCumulativeCounters.longValue() / 1000000.0;
    }

    public void setPeriodicValues(long length, ConcurrentHashMap<Enum, LongAdder> periodicCounters, ConcurrentHashMap<Enum, LongAdder> periodicTotalLatencies) {
        long lengthInSec = length / 1000000L / 1000L;
        for (Enum<E> key : this.keys) {
            LongAdder periodicCounter = periodicCounters.get(key);
            this.periodicCounters.put(key, periodicCounter.longValue());
            LongAdder periodicTotalLatency = periodicTotalLatencies.get(key);
            this.periodicAverageLatencies.put(key, periodicTotalLatency.doubleValue() / periodicCounter.doubleValue() / 1000000.0);
            if (lengthInSec > 0L) {
                this.periodicTps.put(key, periodicCounter.longValue() / lengthInSec);
            } else {
                this.periodicTps.put(key, periodicCounter.longValue());
            }
            StatisticsPeek statisticsPeek = this;
            Long.valueOf(statisticsPeek.sumOfPeriodicCounters + periodicCounter.longValue());
            statisticsPeek.sumOfPeriodicCounters = statisticsPeek.sumOfPeriodicCounters;
            this.averageOfPeriodicAverageLatencies += periodicTotalLatency.doubleValue();
            statisticsPeek = this;
            Long.valueOf(statisticsPeek.sumOfPeriodicTps + this.periodicTps.get(key));
            statisticsPeek.sumOfPeriodicTps = statisticsPeek.sumOfPeriodicTps;
        }
        this.averageOfPeriodicAverageLatencies = this.averageOfPeriodicAverageLatencies / (double)this.sumOfPeriodicCounters.longValue() / 1000000.0;
    }

    public void addAll(Map<String, StatisticsPeek<E>> statisticsPeeks) {
        Set<String> names = statisticsPeeks.keySet();
        int validPeriodicLatencies = 0;
        int validCumulativeLatencies = 0;
        for (Enum<E> key : this.keys) {
            long periodicCounter = 0L;
            long cumulativeCounter = 0L;
            double periodicAverageLatencyInMs = 0.0;
            double cumulativeAverageLatencyInMs = 0.0;
            long periodicTps = 0L;
            long cumulativeTps = 0L;
            for (String string : names) {
                StatisticsPeek<E> peek = statisticsPeeks.get(string);
                periodicCounter += peek.getPeriodicCounters(key).longValue();
                cumulativeCounter += peek.getCumulativeCounters(key).longValue();
                periodicAverageLatencyInMs += peek.getPeriodicAverageLatencyInMs(key).doubleValue();
                cumulativeAverageLatencyInMs += peek.getCumulativeAverageLatencyInMs(key).doubleValue();
                periodicTps += peek.getPeriodicTps(key).longValue();
                cumulativeTps += peek.getCumulativeTps(key).longValue();
            }
            this.periodicCounters.put(key, periodicCounter);
            this.cumulativeCounters.put(key, cumulativeCounter);
            this.periodicAverageLatencies.put(key, periodicAverageLatencyInMs / (double)names.size());
            this.cumulativeAverageLatencies.put(key, cumulativeAverageLatencyInMs / (double)names.size());
            this.periodicTps.put(key, periodicTps);
            this.cumulativeTps.put(key, cumulativeTps);
            StatisticsPeek i$ = this;
            Long.valueOf(i$.sumOfPeriodicCounters + periodicCounter);
            i$.sumOfPeriodicCounters = i$.sumOfPeriodicCounters;
            Double currPeriodicAvLat = this.periodicAverageLatencies.get(key);
            if (!currPeriodicAvLat.isNaN()) {
                this.averageOfPeriodicAverageLatencies += currPeriodicAvLat.doubleValue();
                ++validPeriodicLatencies;
            }
            StatisticsPeek statisticsPeek = this;
            Long.valueOf(statisticsPeek.sumOfPeriodicTps + periodicTps);
            statisticsPeek.sumOfPeriodicTps = statisticsPeek.sumOfPeriodicTps;
            StatisticsPeek statisticsPeek2 = this;
            Long.valueOf(statisticsPeek2.sumOfCumulativeCounters + cumulativeCounter);
            statisticsPeek2.sumOfCumulativeCounters = statisticsPeek2.sumOfCumulativeCounters;
            Double d = this.cumulativeAverageLatencies.get(key);
            if (!d.isNaN()) {
                this.averageOfCumulativeAverageLatencies += d.doubleValue();
                ++validCumulativeLatencies;
            }
            StatisticsPeek statisticsPeek3 = this;
            Long.valueOf(statisticsPeek3.sumOfCumulativeTps + cumulativeTps);
            statisticsPeek3.sumOfCumulativeTps = statisticsPeek3.sumOfCumulativeTps;
        }
        this.averageOfPeriodicAverageLatencies /= (double)validPeriodicLatencies;
        this.averageOfCumulativeAverageLatencies /= (double)validCumulativeLatencies;
    }

    public Long getPeriodicCounters(Enum<E> key) {
        return this.periodicCounters.get(key);
    }

    public Double getPeriodicAverageLatencyInMs(Enum<E> key) {
        return this.periodicAverageLatencies.get(key);
    }

    public Long getPeriodicTps(Enum<E> key) {
        return this.periodicTps.get(key);
    }

    public long getSumOfPeriodicCounters() {
        return this.sumOfPeriodicCounters;
    }

    public double getAverageOfPeriodicAverageLatencies() {
        return this.averageOfPeriodicAverageLatencies;
    }

    public long getSumOfPeriodicTps() {
        return this.sumOfPeriodicTps;
    }

    public Long getCumulativeCounters(Enum<E> key) {
        return this.cumulativeCounters.get(key);
    }

    public Double getCumulativeAverageLatencyInMs(Enum<E> key) {
        return this.cumulativeAverageLatencies.get(key);
    }

    public Long getCumulativeTps(Enum<E> key) {
        return this.cumulativeTps.get(key);
    }

    public long getSumOfCumulativeCounters() {
        return this.sumOfCumulativeCounters;
    }

    public double getAverageOfCumulativeAverageLatencies() {
        return this.averageOfCumulativeAverageLatencies;
    }

    public long getSumOfCumulativeTps() {
        return this.sumOfCumulativeTps;
    }
}

