/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics;

import io.rainfall.Reporter;
import io.rainfall.configuration.ReportingConfig;
import io.rainfall.statistics.RuntimeStatisticsHolder;
import io.rainfall.statistics.StatisticsPeekHolder;
import java.util.Set;
import java.util.TimerTask;

public class StatisticsThread<E extends Enum<E>>
extends TimerTask {
    private RuntimeStatisticsHolder<E> statisticsHolder;
    private ReportingConfig<E> reportingConfig;

    public StatisticsThread(RuntimeStatisticsHolder<E> statisticsHolder, ReportingConfig<E> reportingConfig) {
        Thread.currentThread().setName("Rainfall-core Statistics Thread");
        this.statisticsHolder = statisticsHolder;
        this.reportingConfig = reportingConfig;
    }

    @Override
    public void run() {
        StatisticsPeekHolder<E> peek = this.statisticsHolder.peek();
        Set<Reporter<E>> reporters = this.reportingConfig.getLogReporters();
        for (Reporter<E> reporter : reporters) {
            reporter.report(peek);
        }
    }

    public StatisticsPeekHolder<E> stop() {
        StatisticsPeekHolder<E> peek = this.statisticsHolder.peek();
        Set<Reporter<E>> reporters = this.reportingConfig.getLogReporters();
        for (Reporter<E> reporter : reporters) {
            reporter.summarize(this.statisticsHolder);
        }
        super.cancel();
        return peek;
    }
}

