/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.utils;

public class ConcurrentPseudoRandom {
    private final RandomFunction randomFunction = (RandomFunction)new ThreadLocal<RandomFunction>(){

        @Override
        protected RandomFunction initialValue() {
            return new RandomFunction();
        }
    }.get();

    public long nextLong() {
        return this.randomFunction.nextLong();
    }

    public long nextLong(long seed) {
        return this.randomFunction.nextLong(seed);
    }

    public float nextFloat() {
        return this.randomFunction.nextFloat();
    }

    public float nextFloat(long seed) {
        return this.randomFunction.nextFloat(seed);
    }

    public float nextFloat(float max) {
        return max * this.randomFunction.nextFloat();
    }

    private class RandomFunction {
        long seed = 0x1ED8B55FAC9DECL ^ System.nanoTime();

        private RandomFunction() {
        }

        public long nextLong() {
            long nb = this.nextLong(this.seed);
            this.seed *= 181783497276652981L;
            return nb;
        }

        public long nextLong(long seed) {
            seed ^= seed << 21;
            seed ^= seed >>> 35;
            seed ^= seed << 4;
            return seed;
        }

        public float nextFloat() {
            float nb = this.nextFloat(this.seed);
            this.seed *= 181783497276652981L;
            return nb;
        }

        public float nextFloat(long next) {
            return Math.abs((float)(this.nextLong(next) % 100000L) / 100000.0f);
        }
    }
}

