/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall;

import io.rainfall.Operation;
import io.rainfall.WeightedOperation;
import io.rainfall.utils.RangeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Scenario {
    private String name;
    private final List<RangeMap<WeightedOperation>> operations = new ArrayList<RangeMap<WeightedOperation>>();

    public Scenario(String name) {
        this.name = name;
    }

    public Scenario exec(WeightedOperation ... operations) {
        RangeMap<WeightedOperation> operationRangeMap = new RangeMap<WeightedOperation>();
        for (WeightedOperation operation : operations) {
            operationRangeMap.put(Float.valueOf(operation.getWeight()), operation);
        }
        this.operations.add(operationRangeMap);
        return this;
    }

    public Scenario exec(Operation ... operations) {
        RangeMap<WeightedOperation> operationRangeMap = new RangeMap<WeightedOperation>();
        for (Operation operation : operations) {
            float percent = 1.0f / (float)operations.length;
            operationRangeMap.put(Float.valueOf(percent), new WeightedOperation(Double.valueOf(percent), operation));
        }
        this.operations.add(operationRangeMap);
        return this;
    }

    public static Scenario scenario(String name) {
        return new Scenario(name);
    }

    public List<RangeMap<WeightedOperation>> getOperations() {
        return this.operations;
    }

    public List<String> getDescription() {
        ArrayList<String> desc = new ArrayList<String>();
        desc.add("Scenario : " + this.name);
        int step = 1;
        for (RangeMap<WeightedOperation> operationMap : this.operations) {
            desc.add("Step " + step + ")");
            Collection<WeightedOperation> parallelOperations = operationMap.getAll();
            for (WeightedOperation operation : parallelOperations) {
                desc.addAll(operation.getDescription());
            }
            ++step;
        }
        return desc;
    }

    public static WeightedOperation weighted(Double weight, Operation operation) {
        return new WeightedOperation(weight, operation);
    }

    public static WeightedOperation fixed(Operation operation) {
        return new WeightedOperation(operation);
    }
}

