/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall;

import io.rainfall.Execution;
import io.rainfall.Operation;
import java.util.ArrayList;
import java.util.List;

public class WeightedOperation {
    private float weight = 1.0f;
    private final Operation operation;
    private int weightInPercent;
    private List<String> description;
    private Execution.ExecutionState state;

    public WeightedOperation(Double weight, Operation operation) {
        this.weight = weight.floatValue();
        this.weightInPercent = (int)(100.0 * weight);
        this.operation = operation;
    }

    public WeightedOperation(Operation operation) {
        this.weight = -1.0f;
        this.operation = operation;
    }

    public float getWeight() {
        return this.weight;
    }

    public int getWeightInPercent() {
        return this.weightInPercent;
    }

    public List<String> getDescription() {
        ArrayList<String> desc = new ArrayList<String>();
        desc.add("Operation weight : " + this.weightInPercent + " % ");
        desc.addAll(this.operation.getDescription());
        return desc;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Execution.ExecutionState getExecutionState() {
        return this.state;
    }

    public void markExecutionState(Execution.ExecutionState state) {
        this.state = state;
    }
}

