/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.configuration;

import io.rainfall.Configuration;
import io.rainfall.configuration.DistributedConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencyConfig
extends Configuration {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrencyConfig.class);
    private int threadsCount = 1;
    private final Map<Integer, AtomicLong> iterationsCountPerThread = new HashMap<Integer, AtomicLong>();
    private long timeoutInSeconds = 600L;

    public static ConcurrencyConfig concurrencyConfig() {
        return new ConcurrencyConfig();
    }

    public ConcurrencyConfig threads(int nbThreads) {
        this.threadsCount = nbThreads;
        return this;
    }

    public ConcurrencyConfig timeout(int nb, TimeUnit unit) {
        this.timeoutInSeconds = unit.toSeconds(nb);
        return this;
    }

    public int getThreadsCount() {
        return this.threadsCount;
    }

    public long getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNbIterationsForThread(DistributedConfig distributedConfig, int threadNb, long iterationsCount) {
        Map<Integer, AtomicLong> map = this.iterationsCountPerThread;
        synchronized (map) {
            int clientsCount = 1;
            if (distributedConfig != null) {
                clientsCount = distributedConfig.getNbClients();
            }
            if (iterationsCount % (long)clientsCount != 0L) {
                logger.warn("The iterations count is not a multiple of clients count, therefore the iterations count will be approximative.");
            }
            long iterationsCountForClient = iterationsCount / (long)clientsCount;
            if (this.iterationsCountPerThread.size() == 0) {
                int i;
                for (int i2 = 0; i2 < this.threadsCount; ++i2) {
                    this.iterationsCountPerThread.put(i2, new AtomicLong());
                }
                long roundedValue = new Double(Math.floor(iterationsCountForClient / (long)this.threadsCount)).longValue();
                for (i = 0; i < this.threadsCount; ++i) {
                    this.iterationsCountPerThread.get(i).addAndGet(roundedValue);
                    iterationsCountForClient -= roundedValue;
                }
                i = 0;
                while (iterationsCountForClient > 0L) {
                    this.iterationsCountPerThread.get(i % this.threadsCount).incrementAndGet();
                    ++i;
                    --iterationsCountForClient;
                }
            }
        }
        return this.iterationsCountPerThread.get(threadNb).longValue();
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList("Threadpool size : " + this.threadsCount);
    }

    public void clearNbIterationsForThread() {
        this.iterationsCountPerThread.clear();
    }
}

