/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.configuration;

import io.rainfall.Configuration;
import io.rainfall.utils.RainfallClient;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class DistributedConfig
extends Configuration {
    private InetSocketAddress masterAddress;
    private int nbClients;
    private RainfallClient currentClient;

    private DistributedConfig(InetSocketAddress masterAddress, int nbClients) {
        this.masterAddress = masterAddress;
        this.nbClients = nbClients;
    }

    public static DistributedConfig distributedConfig(InetSocketAddress masterAddress, int nbClients) {
        return new DistributedConfig(masterAddress, nbClients);
    }

    public static InetSocketAddress address(String hostname, int port) {
        return new InetSocketAddress(hostname, port);
    }

    public int getNbClients() {
        return this.nbClients;
    }

    public InetSocketAddress getMasterAddress() {
        return this.masterAddress;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> desc = new ArrayList<String>();
        desc.add("Number of testing clients = " + this.nbClients);
        return desc;
    }

    public void setCurrentClient(RainfallClient currentClient) {
        this.currentClient = currentClient;
    }

    public RainfallClient getCurrentClient() {
        return this.currentClient;
    }

    public int getCurrentClientId() {
        return this.currentClient.getClientId();
    }
}

