/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.generator;

import io.rainfall.ObjectGenerator;
import java.util.UUID;

public class RandomStringGenerator
implements ObjectGenerator<String> {
    private final String randomString;
    private int length;

    public RandomStringGenerator(int length) {
        this.length = length;
        if (length <= 0) {
            throw new IllegalStateException("Can not generate a String with a length less or equal to 0");
        }
        String baseRandom = UUID.randomUUID().toString();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1 + length / baseRandom.length(); ++i) {
            sb.append(baseRandom);
        }
        this.randomString = sb.subSequence(0, length).toString();
    }

    @Override
    public String generate(Long seed) {
        return (seed.toString() + this.randomString).substring(0, this.length);
    }

    @Override
    public String getDescription() {
        return "String (random, String length = " + this.length + ")";
    }

    public static ObjectGenerator<String> fixedLength(int length) {
        return new RandomStringGenerator(length);
    }
}

