/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.generator;

import io.rainfall.ObjectGenerator;

public class VerifiedValueGenerator<K>
implements ObjectGenerator<VerifiedValue> {
    private ObjectGenerator<K> keyGenerator;

    public VerifiedValueGenerator(ObjectGenerator<K> keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    @Override
    public VerifiedValue generate(Long seed) {
        return new VerifiedValue<K>(seed, this.keyGenerator.generate(seed));
    }

    @Override
    public String getDescription() {
        return "VerifiedValue (custom object, with equality assertion)";
    }

    public static class VerifiedValue<K> {
        private final K k;
        private Long key;

        public VerifiedValue(Long key, K k) {
            this.key = key;
            this.k = k;
        }

        public Long getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VerifiedValue)) {
                return false;
            }
            return ((VerifiedValue)obj).getKey().equals(this.getKey());
        }
    }
}

