/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics;

import io.rainfall.statistics.Statistics;
import io.rainfall.statistics.StatisticsPeek;
import io.rainfall.statistics.collector.StatisticsCollector;
import io.rainfall.statistics.exporter.Exporter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jsr166e.LongAdder;

public class StatisticsPeekHolder<E extends Enum<E>> {
    public static final String ALL = "ALL";
    private final Enum<E>[] resultsReported;
    private final ConcurrentHashMap<String, LongAdder> assertionsErrors;
    private Map<String, StatisticsPeek<E>> statisticsPeeks = new ConcurrentHashMap<String, StatisticsPeek<E>>();
    private Map<String, Exporter> extraCollectedStatistics = new ConcurrentHashMap<String, Exporter>();
    private StatisticsPeek<E> totalStatisticsPeeks = null;
    private long timestamp;

    public StatisticsPeekHolder(Enum<E>[] resultsReported, Map<String, Statistics<E>> statisticsMap, Set<StatisticsCollector> statisticsCollectors, ConcurrentHashMap<String, LongAdder> assertionsErrors) {
        this.resultsReported = resultsReported;
        this.assertionsErrors = assertionsErrors;
        this.timestamp = System.currentTimeMillis();
        for (String name : statisticsMap.keySet()) {
            this.statisticsPeeks.put(name, statisticsMap.get(name).peek(this.timestamp));
        }
        this.totalStatisticsPeeks = new StatisticsPeek<E>(ALL, this.resultsReported, this.timestamp);
        this.totalStatisticsPeeks.addAll(this.statisticsPeeks);
        for (StatisticsCollector statisticsCollector : statisticsCollectors) {
            this.extraCollectedStatistics.put(statisticsCollector.getName(), statisticsCollector.peek());
        }
    }

    public StatisticsPeek<E> getStatisticsPeeks(String name) {
        return this.statisticsPeeks.get(name);
    }

    public Long getAssertionsErrorsCount(String name) {
        return this.assertionsErrors.get(name).longValue();
    }

    public Set<String> getStatisticsPeeksNames() {
        return this.statisticsPeeks.keySet();
    }

    public StatisticsPeek<E> getTotalStatisticsPeeks() {
        return this.totalStatisticsPeeks;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Enum<E>[] getResultsReported() {
        return this.resultsReported;
    }

    public Map<String, Exporter> getExtraCollectedStatistics() {
        return this.extraCollectedStatistics;
    }

    public Long getTotalAssertionsErrorsCount() {
        Long totalAssertionsErrorsCount = 0L;
        for (LongAdder count : this.assertionsErrors.values()) {
            totalAssertionsErrorsCount = totalAssertionsErrorsCount + count.longValue();
        }
        return totalAssertionsErrorsCount;
    }
}

