/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics.monitor;

import io.rainfall.reporting.HtmlReporter;
import io.rainfall.statistics.collector.StatisticsCollector;
import io.rainfall.statistics.exporter.Exporter;
import io.rainfall.statistics.exporter.HtmlExporter;
import io.rainfall.statistics.exporter.TextExporter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class GcStatisticsCollector
implements StatisticsCollector {
    private static final String GARBAGE_COLLECTION_NOTIFICATION = "com.sun.management.gc.notification";
    private Writer gcOutput;
    public static final String GC_STATS = "GC_STATS";
    public HtmlReporter reporterUtils = new HtmlReporter();
    private final Queue<GcStats> gcStatsQueue = new ConcurrentLinkedQueue<GcStats>();
    private final NotificationListener listener = new NotificationListener(){

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification.getType().equals(GcStatisticsCollector.GARBAGE_COLLECTION_NOTIFICATION)) {
                CompositeData userData = (CompositeData)notification.getUserData();
                CompositeData gcInfo = (CompositeData)userData.get("gcInfo");
                GcStats gcStats = new GcStats((Long)gcInfo.get("duration"), (String)userData.get("gcAction"), (Long)gcInfo.get("startTime"), (String)userData.get("gcCause"), (String)userData.get("gcName"));
                GcStatisticsCollector.this.gcStatsQueue.add(gcStats);
            }
        }
    };

    @Override
    public void initialize() {
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcMxBean);
            emitter.addNotificationListener(this.listener, null, null);
        }
    }

    @Override
    public void terminate() {
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcMxBean);
            try {
                emitter.removeNotificationListener(this.listener);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {}
        }
    }

    @Override
    public Exporter peek() {
        return new GcStatisticsExporter();
    }

    @Override
    public String getName() {
        return GC_STATS;
    }

    public class GcStatisticsExporter
    implements HtmlExporter,
    TextExporter {
        private HtmlReporter reporterUtils = new HtmlReporter();
        private String gcFile = "gc.csv";
        List<GcStats> gcStatsList;
        long jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();

        public GcStatisticsExporter() {
            GcStats gcStats;
            this.gcStatsList = new ArrayList<GcStats>();
            while ((gcStats = (GcStats)GcStatisticsCollector.this.gcStatsQueue.poll()) != null) {
                this.gcStatsList.add(gcStats);
            }
        }

        @Override
        public void ouputText() {
        }

        @Override
        public void ouputCsv(String basedir) throws Exception {
            String gcFilename = basedir + File.separatorChar + this.gcFile;
            GcStatisticsCollector.this.gcOutput = new BufferedWriter(new FileWriter(gcFilename, true));
            if (new File(gcFilename).length() == 0L) {
                this.reporterUtils.addHeader(GcStatisticsCollector.this.gcOutput, GcStats.Header.values());
            }
            for (GcStats gcStats : this.gcStatsList) {
                GcStatisticsCollector.this.gcOutput.append(this.toCsv(gcStats)).append("\n");
            }
            GcStatisticsCollector.this.gcOutput.close();
        }

        @Override
        public String outputHtml() {
            return "    function reportGc(filename, title) {\n        $(\"#gc-box\").append(\"<div id='\" + filename + 'gc' + \"' style='height: 550px;width: 1200px;'><div class='title'/><div class='graph'/></div>\");\n        d3.csv(filename + \".csv\", function (data) { processData(data, filename + 'gc', title, 'Pause Time (ms)') });\n    }\n\n$('body').append('<div class=\"border\"><h1><a name=\"gc\">Garbage Collection</a></h1><div id=\"gc-box\"></div></div><br/>');\nreportGc('gc', 'GC Time');\n";
        }

        private String toCsv(GcStats gcStats) {
            return String.valueOf(this.reporterUtils.formatTimestampInNano(this.jvmStartTime + gcStats.getStartTimestamp())) + "," + gcStats.getDuration() + "," + gcStats.getAction() + "," + gcStats.getCause() + "," + gcStats.getName();
        }
    }

    public static class GcStats {
        private final long startTimestamp;
        private final long duration;
        private final String action;
        private final String cause;
        private final String name;

        public GcStats(long duration, String action, long startTimestamp, String cause, String name) {
            this.duration = duration;
            this.action = action;
            this.startTimestamp = startTimestamp;
            this.cause = cause;
            this.name = name;
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        public long getDuration() {
            return this.duration;
        }

        public String getAction() {
            return this.action;
        }

        public String getCause() {
            return this.cause;
        }

        public String getName() {
            return this.name;
        }

        public static enum Header {
            DURATION,
            ACTION,
            CAUSE,
            NAME;

        }
    }
}

