/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.utils;

import io.rainfall.TestException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainfallClient
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String currentSessionId;
    private final InetSocketAddress socketAddress;
    private Socket socket = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private int clientId;
    private AtomicReference<TestException> testException = new AtomicReference();
    private boolean running;
    private boolean canStart = false;

    public RainfallClient(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.setupConnection();
            this.logger.info("[Rainfall client] Ready for commands");
            this.command("READY");
            while (this.running) {
                try {
                    String[] uuidResponse;
                    String response = this.in.readLine();
                    if (response == null) {
                        this.logger.debug("[Rainfall client] Possible network issue - Increasing wait time before fetching next Rainfall server command");
                        Thread.sleep(1000L);
                        continue;
                    }
                    this.logger.debug("[Rainfall client] Received command {} from Rainfall server", (Object)response);
                    if (response.startsWith("GO")) {
                        this.logger.debug("[Rainfall client] Received GO from Rainfall server. Test can start");
                        uuidResponse = response.split(",");
                        this.currentSessionId = uuidResponse[1];
                        this.clientId = Integer.parseInt(uuidResponse[2]);
                        this.canStart = true;
                        this.logger.debug("UUID received = {}, Rainfall Client id = {}", (Object)this.currentSessionId, (Object)this.clientId);
                        continue;
                    }
                    if (response.startsWith("SHUTDOWN")) {
                        uuidResponse = response.split(",");
                        if (this.currentSessionId.equalsIgnoreCase(uuidResponse[1])) {
                            this.running = false;
                            continue;
                        }
                        this.logger.info("Received command from wrong test session (expected: {}, received: {}, possible multiple tests running in parallel)", (Object)this.currentSessionId, (Object)uuidResponse[1]);
                        continue;
                    }
                    Thread.sleep(500L);
                }
                catch (IOException e) {
                    throw new TestException("Rainfall client couldn't read from the Rainfall server", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (TestException e) {
            this.testException.set(e);
        }
        finally {
            try {
                this.shutdown();
            }
            catch (IOException e) {
                this.logger.debug("[Rainfall client] Issue when shutting down connections", (Throwable)e);
            }
        }
    }

    private void setupConnection() throws TestException {
        try {
            this.socket = new Socket(this.socketAddress.getAddress(), this.socketAddress.getPort());
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new PrintWriter(this.socket.getOutputStream());
            this.running = true;
            this.logger.info("[Rainfall client] Connection successfull to Server");
        }
        catch (IOException e) {
            throw new TestException("Rainfall server is not started on " + this.socketAddress.toString(), e);
        }
    }

    private void command(String command) {
        this.out.println(command);
        this.out.flush();
    }

    public void sendReport() throws TestException {
        this.out.println("FINISHED," + this.currentSessionId);
        this.out.flush();
    }

    private void shutdown() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        this.logger.debug("[Rainfall Client] Connection Closed");
    }

    public int getClientId() {
        return this.clientId;
    }

    public AtomicReference<TestException> getTestException() {
        return this.testException;
    }

    public boolean canStart() {
        return this.canStart;
    }
}

