/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.utils;

import io.rainfall.utils.ConcurrentPseudoRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RangeMap<E> {
    private final Map<Float, E> values = new HashMap<Float, E>();
    private final List<Range> keys = new LinkedList<Range>();
    private Float higherBound = Float.valueOf(0.0f);
    private final ConcurrentPseudoRandom rnd = new ConcurrentPseudoRandom();

    public synchronized E put(Float key, E value) {
        E put = this.values.put(this.higherBound, value);
        this.keys.add(new Range(this.higherBound.floatValue(), this.higherBound.floatValue() + key.floatValue(), this.higherBound));
        this.higherBound = Float.valueOf(this.higherBound.floatValue() + key.floatValue());
        return put;
    }

    public E get(float key) {
        for (Range range : this.keys) {
            if (!range.contains(key)) continue;
            return this.values.get(range.getKey());
        }
        return null;
    }

    public Float getHigherBound() {
        return this.higherBound;
    }

    public Collection<E> getAll() {
        return this.values.values();
    }

    public class Range {
        private float low;
        private float high;
        private Float key;

        public Range(float low, float high, Float key) {
            this.low = low;
            this.high = high;
            this.key = key;
        }

        public boolean contains(float key) {
            return this.low <= key && this.high > key;
        }

        public Float getKey() {
            return this.key;
        }
    }
}

