package io.rainfall.utils;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * @author Aurelien Broszniowski
 */
public class Barrier extends Throwable {
  private final String barrierName;
  private final int parties;

  public Barrier(final String barrierName, final int parties) {
    this.barrierName = barrierName;
    this.parties = parties;
  }

  /**
   * Returns the number of parties required to trip this barrier.
   *
   * @return the number of parties required to trip this barrier
   */
  int getParties() {
    return parties;
  }

  public int await(long timeout, TimeUnit unit) throws InterruptedException, BrokenBarrierException, TimeoutException {
    unit.toNanos(timeout);
    return 0;
  }

}
