/*
 * Copyright 2020 Rapidw
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.rapidw.mqtt.client.v3_1_1;

import io.rapidw.mqtt.codec.v3_1_1.MqttV311ConnectReturnCode;


public class MqttConnectionException extends MqttClientException {

    private MqttV311ConnectReturnCode connectReturnCode;

    public MqttConnectionException(MqttV311ConnectReturnCode connectReturnCode) {
        super("connect failed, return code is " + connectReturnCode.name());
    }

    public MqttV311ConnectReturnCode getConnectReturnCode() {
        return connectReturnCode;
    }
}
