/*
 * Decompiled with CFR 0.152.
 */
package io.rapidw.mqtt.codec;

import io.netty.handler.codec.DecoderException;
import java.util.HashMap;
import java.util.Map;

public enum MqttConnectReturnCode {
    CONNECTION_ACCEPTED(0),
    CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION(1),
    CONNECTION_REFUSED_IDENTIFIER_REJECTED(2),
    CONNECTION_REFUSED_SERVER_UNAVAILABLE(3),
    CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD(4),
    CONNECTION_REFUSED_NOT_AUTHORIZED(5);

    private static Map<Byte, MqttConnectReturnCode> valueMap;
    private final byte byteValue;

    private MqttConnectReturnCode(byte byteValue) {
        this.byteValue = byteValue;
    }

    public byte byteValue() {
        return this.byteValue;
    }

    public static MqttConnectReturnCode of(byte b) {
        MqttConnectReturnCode code = valueMap.get(b);
        if (!valueMap.containsKey(b)) {
            throw new DecoderException("unknown connect return code: " + (b & 0xFF));
        }
        return code;
    }

    static {
        valueMap = new HashMap<Byte, MqttConnectReturnCode>();
        for (MqttConnectReturnCode code : MqttConnectReturnCode.values()) {
            valueMap.put(code.byteValue, code);
        }
    }
}

