/*
 * Decompiled with CFR 0.152.
 */
package io.rapidw.mqtt.codec;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.ReplayingDecoder;
import io.rapidw.mqtt.codec.MqttConnAckPacket;
import io.rapidw.mqtt.codec.MqttConnectPacket;
import io.rapidw.mqtt.codec.MqttConnectReturnCode;
import io.rapidw.mqtt.codec.MqttDisconnectPacket;
import io.rapidw.mqtt.codec.MqttPacket;
import io.rapidw.mqtt.codec.MqttPacketType;
import io.rapidw.mqtt.codec.MqttPingReqPacket;
import io.rapidw.mqtt.codec.MqttPingRespPacket;
import io.rapidw.mqtt.codec.MqttPublishPacket;
import io.rapidw.mqtt.codec.MqttQosLevel;
import io.rapidw.mqtt.codec.MqttSubAckPacket;
import io.rapidw.mqtt.codec.MqttSubscribePacket;
import io.rapidw.mqtt.codec.MqttTopicAndQosLevel;
import io.rapidw.mqtt.codec.MqttUnsubAckPacket;
import io.rapidw.mqtt.codec.MqttUnsubscribePacket;
import io.rapidw.mqtt.codec.MqttWill;
import io.rapidw.mqtt.codec.ValidationUtils;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class MqttDecoder
extends ReplayingDecoder<DecoderState> {
    private MqttPacket packet;
    private short flags;
    private int remainingLength;

    public MqttDecoder() {
        super((Object)DecoderState.READ_FIXED_HEADER);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        switch ((DecoderState)((Object)this.state())) {
            case READ_FIXED_HEADER: {
                short b1 = in.readUnsignedByte();
                this.flags = (short)(b1 & 0xF);
                this.remainingLength = this.readRemainingLength(in);
                switch (MqttPacketType.of(b1 >> 4)) {
                    case CONNECT: {
                        this.packet = new MqttConnectPacket();
                        this.validateConnect();
                        break;
                    }
                    case CONNACK: {
                        this.packet = new MqttConnAckPacket();
                        this.validateConnAck();
                        break;
                    }
                    case PUBLISH: {
                        this.packet = new MqttPublishPacket();
                        break;
                    }
                    case SUBSCRIBE: {
                        this.packet = new MqttSubscribePacket();
                        break;
                    }
                    case SUBACK: {
                        this.packet = new MqttSubAckPacket();
                        this.validateSubAck();
                        break;
                    }
                    case UNSUBSCRIBE: {
                        this.packet = new MqttUnsubscribePacket();
                        this.validateUnsubscribe();
                        break;
                    }
                    case UNSUBACK: {
                        this.packet = new MqttUnsubAckPacket();
                        this.validateUnsubAck();
                        break;
                    }
                    case PINGREQ: {
                        this.packet = MqttPingReqPacket.INSTANTCE;
                        this.validatePacketWithoutVariableHeaderAndPayload();
                        break;
                    }
                    case PINGRESP: {
                        this.packet = MqttPingRespPacket.INSTANCE;
                        this.validatePacketWithoutVariableHeaderAndPayload();
                        break;
                    }
                    case DISCONNECT: {
                        this.packet = MqttDisconnectPacket.INSTANCE;
                        this.validatePacketWithoutVariableHeaderAndPayload();
                    }
                }
                this.checkpoint((Object)DecoderState.READ_VARIABLE_HEADER);
            }
            case READ_VARIABLE_HEADER: {
                switch (this.packet.getType()) {
                    case CONNECT: {
                        this.readConnectVariableHeader(in, (MqttConnectPacket)this.packet);
                        break;
                    }
                    case CONNACK: {
                        this.readConnAckVariableHeader(in, (MqttConnAckPacket)this.packet);
                        break;
                    }
                    case PUBLISH: {
                        this.readPublishVariableHeader(in, (MqttPublishPacket)this.packet);
                        break;
                    }
                    case SUBSCRIBE: {
                        this.readSubscribeVariableHeader(in, (MqttSubscribePacket)this.packet);
                        break;
                    }
                    case SUBACK: {
                        this.readSubAckVariableHeader(in, (MqttSubAckPacket)this.packet);
                        break;
                    }
                    case UNSUBSCRIBE: {
                        this.readUnsubscribeVariableHeader(in, (MqttUnsubscribePacket)this.packet);
                        break;
                    }
                    case UNSUBACK: {
                        this.readUnsubAckVariableHeader(in, (MqttUnsubAckPacket)this.packet);
                    }
                }
                this.checkpoint((Object)DecoderState.READ_PAYLOAD);
            }
            case READ_PAYLOAD: {
                switch (this.packet.getType()) {
                    case CONNECT: {
                        this.readConnectPayload(in, (MqttConnectPacket)this.packet);
                        break;
                    }
                    case SUBSCRIBE: {
                        this.readSubscribePayload(in, (MqttSubscribePacket)this.packet);
                        break;
                    }
                    case SUBACK: {
                        this.readSubAckPayload(in, (MqttSubAckPacket)this.packet);
                        break;
                    }
                    case UNSUBSCRIBE: {
                        this.readUnsubscribePayload(in, (MqttUnsubscribePacket)this.packet);
                    }
                }
                this.checkpoint((Object)DecoderState.READ_FIXED_HEADER);
                out.add(this.packet);
            }
        }
    }

    private void validatePacketWithoutVariableHeaderAndPayload() {
        if (this.flags != 0 || this.remainingLength != 0) {
            throw new DecoderException("invalid packet without varheader and payload");
        }
    }

    private void validateConnect() {
        if ((this.flags & 0xF) != 0) {
            throw new DecoderException("[MQTT-3.1.2-3] connect packet reversed flag is not zero");
        }
    }

    private void validateConnAck() {
        if (this.flags != 0) {
            throw new DecoderException("invalid conack fixedheader flags");
        }
        if (this.remainingLength != 2) {
            throw new DecoderException("invalid conack remaining length");
        }
    }

    private void validateSubscribe() {
        if (this.flags != 2) {
            throw new DecoderException("[MQTT-3.8.1-1] invalid subscribe flags");
        }
    }

    private void validateSubAck() {
        if (this.flags != 0) {
            throw new DecoderException("invalid suback packet flags");
        }
    }

    private void validateUnsubscribe() {
        if (this.flags != 2) {
            throw new DecoderException("[MQTT-3.10.1-1] invalid unsubscribe flags");
        }
    }

    private void validateUnsubAck() {
        if (this.flags != 0) {
            throw new DecoderException("invalid unsuback flags");
        }
        if (this.remainingLength != 2) {
            throw new DecoderException("invalid unsuback remaining length");
        }
    }

    private void readConnectVariableHeader(ByteBuf buf, MqttConnectPacket packet) {
        DecodedResult<String> protocolName = MqttDecoder.readString(buf);
        if (!protocolName.getValue().equals("MQTT")) {
            throw new DecoderException("[MQTT-3.1.2-1] invalid protocol name");
        }
        if (buf.readUnsignedByte() != 4) {
            throw new DecoderException("[MQTT-3.1.2-1] invalid protocol level");
        }
        short b = buf.readUnsignedByte();
        packet.setCleanSession(MqttDecoder.isSet(b, 1));
        boolean usernameFlag = MqttDecoder.isSet(b, 7);
        boolean passwordFlag = MqttDecoder.isSet(b, 6);
        if (!usernameFlag && passwordFlag) {
            throw new DecoderException("invalid connect packet: username not present but password present");
        }
        packet.setUsernameFlag(usernameFlag);
        packet.setPasswordFlag(passwordFlag);
        if (MqttDecoder.isSet(b, 2)) {
            MqttWill.MqttWillBuilder willBuilder = MqttWill.builder();
            willBuilder.qosLevel(MqttQosLevel.of((b & 0x18) >> 3));
            willBuilder.retain(MqttDecoder.isSet(b, 5));
            packet.setWillBuilder(willBuilder);
        } else if (!(MqttDecoder.isSet(b, 3) || MqttDecoder.isSet(b, 4) || MqttDecoder.isSet(b, 5))) {
            throw new DecoderException("[MQTT-3.1.2-11] If the Will Flag is set to 0 the Will QoS and Will Retain fields in the Connect Flags MUST be set to zero");
        }
        DecodedResult<Integer> keepaliveSeconds = MqttDecoder.readMsbLsb(buf);
        packet.setKeepaliveSeconds(keepaliveSeconds.getValue());
        this.remainingLength -= 10;
    }

    private void readConnectPayload(ByteBuf buf, MqttConnectPacket packet) {
        DecodedResult<String> clientId = MqttDecoder.readString(buf);
        packet.setClientId((String)((DecodedResult)clientId).value);
        this.remainingLength -= ((DecodedResult)clientId).bytesConsumed;
        MqttWill.MqttWillBuilder willBuilder = packet.getWillBuilder();
        if (willBuilder != null) {
            DecodedResult<String> willTopic = MqttDecoder.readString(buf);
            willBuilder.topic((String)((DecodedResult)willTopic).value);
            this.remainingLength -= ((DecodedResult)willTopic).bytesConsumed;
            DecodedResult<byte[]> willMessage = MqttDecoder.readByteArray(buf);
            willBuilder.message((byte[])((DecodedResult)willMessage).value);
            this.remainingLength -= ((DecodedResult)willMessage).bytesConsumed;
            packet.setWill(willBuilder.build());
        }
        if (packet.isUsernameFlag()) {
            DecodedResult<String> username = MqttDecoder.readString(buf);
            packet.setUsername((String)((DecodedResult)username).value);
            this.remainingLength -= ((DecodedResult)username).bytesConsumed;
        }
        if (packet.isPasswordFlag()) {
            DecodedResult<byte[]> password = MqttDecoder.readByteArray(buf);
            packet.setPassword((byte[])((DecodedResult)password).value);
            this.remainingLength -= ((DecodedResult)password).bytesConsumed;
        }
        if (this.remainingLength != 0) {
            throw new DecoderException("invalid remaining length in connect packet");
        }
    }

    private void readConnAckVariableHeader(ByteBuf buf, MqttConnAckPacket packet) {
        short b1 = buf.readUnsignedByte();
        if ((b1 & 0xFE) != 0) {
            throw new DecoderException("invalid conack flags");
        }
        boolean sessionPresent = MqttDecoder.isSet(b1, 0);
        byte b2 = buf.readByte();
        MqttConnectReturnCode code = MqttConnectReturnCode.of(b2);
        if (code != MqttConnectReturnCode.CONNECTION_ACCEPTED && sessionPresent) {
            throw new DecoderException("[MQTT-3.2.2-4] CONNACK packet containing a non-zero return code it MUST set Session Present to 0");
        }
        packet.setSessionPresent(sessionPresent);
        packet.setConnectReturnCode(code);
    }

    private void readSubAckVariableHeader(ByteBuf buf, MqttSubAckPacket packet) {
        DecodedResult<Integer> packetId = MqttDecoder.readPacketId(buf);
        this.remainingLength -= ((DecodedResult)packetId).bytesConsumed;
        packet.setPacketId((Integer)((DecodedResult)packetId).value);
    }

    private void readSubAckPayload(ByteBuf buf, MqttSubAckPacket packet) {
        LinkedList<MqttQosLevel> qosLevelList = new LinkedList<MqttQosLevel>();
        for (int i = this.remainingLength; i > 0; --i) {
            qosLevelList.add(MqttQosLevel.of(buf.readByte()));
        }
        packet.setQosLevels(qosLevelList);
    }

    private void readPublishVariableHeader(ByteBuf buf, MqttPublishPacket packet) {
        MqttQosLevel qosLevel;
        if (MqttDecoder.isSet(this.flags, 3)) {
            packet.setDupFlag(true);
        }
        if (MqttDecoder.isSet(this.flags, 0)) {
            packet.setRetain(true);
        }
        if ((qosLevel = MqttQosLevel.of((this.flags & 6) >> 1)) == MqttQosLevel.AT_MOST_ONCE && packet.isDupFlag()) {
            throw new DecoderException("[MQTT-3.3.1-2] The DUP flag MUST be set to 0 for all QoS 0 messages");
        }
        packet.setQosLevel(qosLevel);
        DecodedResult<String> topic = MqttDecoder.readString(buf);
        packet.setTopic((String)((DecodedResult)topic).value);
        this.remainingLength -= ((DecodedResult)topic).bytesConsumed;
        if (packet.getQosLevel() == MqttQosLevel.AT_LEAST_ONCE || packet.getQosLevel() == MqttQosLevel.EXACTLY_ONCE) {
            DecodedResult<Integer> packetId = MqttDecoder.readPacketId(buf);
            packet.setPacketId(packetId.getValue());
            this.remainingLength -= ((DecodedResult)packetId).bytesConsumed;
        }
        byte[] payload = new byte[this.remainingLength];
        buf.readBytes(payload);
        packet.setPayload(payload);
    }

    private void readSubscribeVariableHeader(ByteBuf buf, MqttSubscribePacket packet) {
        DecodedResult<Integer> packetId = MqttDecoder.readMsbLsb(buf);
        packet.setPacketId(packetId.getValue());
        this.remainingLength -= ((DecodedResult)packetId).bytesConsumed;
    }

    private void readSubscribePayload(ByteBuf buf, MqttSubscribePacket packet) {
        boolean finish = false;
        while (!finish) {
            DecodedResult<String> topicFilter = MqttDecoder.readString(buf);
            this.remainingLength -= ((DecodedResult)topicFilter).bytesConsumed;
            short b = buf.readUnsignedByte();
            if ((b & 0xFC) != 0) {
                throw new DecoderException("[MQTT-3-8.3-4] Reserved bits in the payload must be zero");
            }
            --this.remainingLength;
            packet.getMqttTopicAndQosLevels().add(new MqttTopicAndQosLevel(topicFilter.getValue(), MqttQosLevel.of(b & 3)));
            if (this.remainingLength == 0) {
                finish = true;
            }
            if (this.remainingLength >= 0) continue;
            throw new DecoderException("invalid subscribe remaining length");
        }
    }

    private void readUnsubscribeVariableHeader(ByteBuf buf, MqttUnsubscribePacket packet) {
        DecodedResult<Integer> packetId = MqttDecoder.readMsbLsb(buf);
        packet.setPacketId((Integer)((DecodedResult)packetId).value);
        this.remainingLength -= ((DecodedResult)packetId).bytesConsumed;
    }

    private void readUnsubscribePayload(ByteBuf buf, MqttUnsubscribePacket packet) {
        List<String> topicFilters = packet.getTopicFilters();
        while (this.remainingLength > 0) {
            DecodedResult<String> topicFiler = MqttDecoder.readString(buf);
            topicFilters.add(ValidationUtils.validateTopicFilter((String)((DecodedResult)topicFiler).value));
            this.remainingLength -= ((DecodedResult)topicFiler).bytesConsumed;
        }
        if (this.remainingLength != 0) {
            throw new DecoderException("invalid unsub length");
        }
    }

    private void readUnsubAckVariableHeader(ByteBuf buf, MqttUnsubAckPacket packet) {
        DecodedResult<Integer> packetId = MqttDecoder.readMsbLsb(buf);
        packet.setPacketId((Integer)((DecodedResult)packetId).value);
    }

    private static DecodedResult<String> readString(ByteBuf buffer) {
        DecodedResult<Integer> decodedSize = MqttDecoder.readMsbLsb(buffer);
        Integer size = (Integer)((DecodedResult)decodedSize).value;
        int bytesConsumed = ((DecodedResult)decodedSize).bytesConsumed;
        String s = buffer.toString(buffer.readerIndex(), size.intValue(), StandardCharsets.UTF_8);
        buffer.skipBytes(size.intValue());
        return new DecodedResult<String>(s, bytesConsumed += size.intValue());
    }

    private static DecodedResult<Integer> readMsbLsb(ByteBuf buffer) {
        short msbSize = buffer.readUnsignedByte();
        short lsbSize = buffer.readUnsignedByte();
        int bytesConsumed = 2;
        int result = msbSize << 8 | lsbSize;
        if (result < 0 || result > 65535) {
            throw new DecoderException("invalid MSB LSB value: " + result);
        }
        return new DecodedResult<Integer>(result, 2);
    }

    private static DecodedResult<byte[]> readByteArray(ByteBuf buffer) {
        DecodedResult<Integer> decodedSize = MqttDecoder.readMsbLsb(buffer);
        int size = (Integer)((DecodedResult)decodedSize).value;
        byte[] bytes = new byte[size];
        buffer.readBytes(bytes);
        return new DecodedResult<byte[]>(bytes, ((DecodedResult)decodedSize).bytesConsumed + size);
    }

    private static DecodedResult<Integer> readPacketId(ByteBuf buffer) {
        DecodedResult<Integer> packetId = MqttDecoder.readMsbLsb(buffer);
        ValidationUtils.validatePacketId(packetId.getValue());
        return packetId;
    }

    private static boolean isSet(short b, int pos) {
        return (b & 1 << pos) != 0;
    }

    private int readRemainingLength(ByteBuf buf) {
        short digit;
        int remainingLength = 0;
        int multiplier = 1;
        int loops = 0;
        do {
            digit = buf.readUnsignedByte();
            remainingLength += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0 && ++loops < 4);
        if (loops == 4 && (digit & 0x80) != 0) {
            throw new DecoderException("remaining length exceeds 4 digits");
        }
        return remainingLength;
    }

    private static final class DecodedResult<T> {
        public static DecodedResult<Void> EMPTY = new DecodedResult<Object>(null, 0);
        private final T value;
        private final int bytesConsumed;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public T getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getBytesConsumed() {
            return this.bytesConsumed;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DecodedResult(T value, int bytesConsumed) {
            this.value = value;
            this.bytesConsumed = bytesConsumed;
        }
    }

    static enum DecoderState {
        READ_FIXED_HEADER,
        READ_VARIABLE_HEADER,
        READ_PAYLOAD;

    }
}

