/*
 * Decompiled with CFR 0.152.
 */
package io.rapidw.mqtt.codec;

import io.netty.handler.codec.DecoderException;
import java.util.HashMap;
import java.util.Map;

public enum MqttQosLevel {
    AT_MOST_ONCE(0),
    AT_LEAST_ONCE(1),
    EXACTLY_ONCE(2),
    FAILURE(128);

    private final int value;
    private static Map<Integer, MqttQosLevel> valueMap;

    private MqttQosLevel(int value) {
        this.value = value;
    }

    public static MqttQosLevel of(int value) {
        MqttQosLevel qosLevel = valueMap.get(value);
        if (qosLevel == null) {
            throw new DecoderException("invalid QoS: " + value);
        }
        return qosLevel;
    }

    static {
        valueMap = new HashMap<Integer, MqttQosLevel>();
        for (MqttQosLevel qosLevel : MqttQosLevel.values()) {
            valueMap.put(qosLevel.value, qosLevel);
        }
    }
}

