/*
 * Decompiled with CFR 0.152.
 */
package io.rapidw.mqtt.codec;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.rapidw.mqtt.codec.MqttPacket;
import io.rapidw.mqtt.codec.MqttPacketType;
import io.rapidw.mqtt.codec.MqttQosLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class MqttSubAckPacket
extends MqttPacket {
    private int packetId;
    private List<MqttQosLevel> qosLevels;

    MqttSubAckPacket() {
        super(MqttPacketType.SUBACK);
    }

    private MqttSubAckPacket(int packetId, List<MqttQosLevel> qosLevels) {
        this();
        this.packetId = packetId;
        this.qosLevels = qosLevels;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static MqttSubAckPacketBuilder builder() {
        return new MqttSubAckPacketBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPacketId() {
        return this.packetId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<MqttQosLevel> getQosLevels() {
        return this.qosLevels;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    void setPacketId(int packetId) {
        this.packetId = packetId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    void setQosLevels(List<MqttQosLevel> qosLevels) {
        this.qosLevels = qosLevels;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class MqttSubAckPacketBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int packetId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<MqttQosLevel> qosLevels;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        MqttSubAckPacketBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MqttSubAckPacketBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MqttSubAckPacketBuilder qosLevel(MqttQosLevel qosLevel) {
            if (this.qosLevels == null) {
                this.qosLevels = new ArrayList();
            }
            this.qosLevels.add(qosLevel);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MqttSubAckPacketBuilder qosLevels(Collection<? extends MqttQosLevel> qosLevels) {
            if (this.qosLevels == null) {
                this.qosLevels = new ArrayList();
            }
            this.qosLevels.addAll(qosLevels);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MqttSubAckPacketBuilder clearQosLevels() {
            if (this.qosLevels != null) {
                this.qosLevels.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MqttSubAckPacket build() {
            List<Object> qosLevels;
            switch (this.qosLevels == null ? 0 : this.qosLevels.size()) {
                case 0: {
                    qosLevels = Collections.emptyList();
                    break;
                }
                case 1: {
                    qosLevels = Collections.singletonList(this.qosLevels.get(0));
                    break;
                }
                default: {
                    qosLevels = Collections.unmodifiableList(new ArrayList<MqttQosLevel>(this.qosLevels));
                }
            }
            return new MqttSubAckPacket(this.packetId, qosLevels);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "MqttSubAckPacket.MqttSubAckPacketBuilder(packetId=" + this.packetId + ", qosLevels=" + this.qosLevels + ")";
        }
    }
}

