/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.healthcheck;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import javax.inject.Inject;
import ratpack.codahale.healthcheck.NamedHealthCheck;
import ratpack.codahale.healthcheck.internal.HealthCheckResultRenderer;
import ratpack.codahale.healthcheck.internal.HealthCheckResultsRenderer;
import ratpack.func.Action;
import ratpack.guice.internal.GuiceUtil;
import ratpack.server.Service;
import ratpack.server.StartEvent;

public class CodaHaleHealthCheckModule
extends AbstractModule {
    protected void configure() {
        this.bind(HealthCheckRegistry.class).in(Scopes.SINGLETON);
        this.bind(HealthCheckResultRenderer.class).in(Scopes.SINGLETON);
        this.bind(HealthCheckResultsRenderer.class).in(Scopes.SINGLETON);
        this.bind(Startup.class);
    }

    private static class Startup
    implements Service {
        private final Injector injector;

        @Inject
        public Startup(Injector injector) {
            this.injector = injector;
        }

        public void onStart(StartEvent event) throws Exception {
            final HealthCheckRegistry registry = (HealthCheckRegistry)this.injector.getInstance(HealthCheckRegistry.class);
            GuiceUtil.eachOfType((Injector)this.injector, (TypeToken)TypeToken.of(NamedHealthCheck.class), (Action)new Action<NamedHealthCheck>(){

                public void execute(NamedHealthCheck healthCheck) throws Exception {
                    registry.register(healthCheck.getName(), (HealthCheck)healthCheck);
                }
            });
        }
    }
}

