/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import org.aopalliance.intercept.MethodInterceptor;
import ratpack.codahale.metrics.internal.ConsoleReporterProvider;
import ratpack.codahale.metrics.internal.CsvReporterProvider;
import ratpack.codahale.metrics.internal.GaugeTypeListener;
import ratpack.codahale.metrics.internal.JmxReporterProvider;
import ratpack.codahale.metrics.internal.MeteredMethodInterceptor;
import ratpack.codahale.metrics.internal.MetricRegistryJsonMapper;
import ratpack.codahale.metrics.internal.MetricRegistryPeriodicPublisher;
import ratpack.codahale.metrics.internal.MetricsBroadcaster;
import ratpack.codahale.metrics.internal.RequestTimingHandler;
import ratpack.codahale.metrics.internal.TimedMethodInterceptor;
import ratpack.func.Action;
import ratpack.guice.ConfigurableModule;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.server.Service;
import ratpack.server.StartEvent;
import ratpack.util.ExceptionUtils;

public class CodaHaleMetricsModule
extends ConfigurableModule<Config> {
    public static final String RATPACK_METRIC_REGISTRY = "ratpack-metrics";

    protected void configure() {
        SharedMetricRegistries.remove((String)RATPACK_METRIC_REGISTRY);
        MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)RATPACK_METRIC_REGISTRY);
        this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Metered.class), new MethodInterceptor[]{this.injected(new MeteredMethodInterceptor())});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Timed.class), new MethodInterceptor[]{this.injected(new TimedMethodInterceptor())});
        this.bindListener(Matchers.any(), this.injected(new GaugeTypeListener()));
        this.bind(JmxReporter.class).toProvider(JmxReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(ConsoleReporter.class).toProvider(ConsoleReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(CsvReporter.class).toProvider(CsvReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(MetricRegistryPeriodicPublisher.class).in(Scopes.SINGLETON);
        this.bind(MetricsBroadcaster.class).in(Scopes.SINGLETON);
        this.bind(MetricRegistryJsonMapper.class).in(Scopes.SINGLETON);
        this.bind(Startup.class);
        Multibinder.newSetBinder((Binder)this.binder(), HandlerDecorator.class).addBinding().toProvider(HandlerDecoratorProvider.class);
    }

    private <T> T injected(T instance) {
        this.requestInjection(instance);
        return instance;
    }

    private static class HandlerDecoratorProvider
    implements Provider<HandlerDecorator> {
        private HandlerDecoratorProvider() {
        }

        public HandlerDecorator get() {
            return HandlerDecorator.prepend((Handler)new RequestTimingHandler());
        }
    }

    private static class Startup
    implements Service {
        private final Config config;
        private final Injector injector;

        @Inject
        public Startup(Config config, Injector injector) {
            this.config = config;
            this.injector = injector;
        }

        public void onStart(StartEvent event) throws Exception {
            this.config.getJmx().ifPresent(jmx -> {
                if (jmx.isEnabled()) {
                    ((JmxReporter)this.injector.getInstance(JmxReporter.class)).start();
                }
            });
            this.config.getConsole().ifPresent(console -> {
                if (console.isEnabled()) {
                    ((ConsoleReporter)this.injector.getInstance(ConsoleReporter.class)).start(console.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
                }
            });
            this.config.getCsv().ifPresent(csv -> {
                if (csv.isEnabled()) {
                    ((CsvReporter)this.injector.getInstance(CsvReporter.class)).start(csv.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
                }
            });
            if (this.config.isJvmMetrics()) {
                MetricRegistry metricRegistry = (MetricRegistry)this.injector.getInstance(MetricRegistry.class);
                metricRegistry.registerAll((MetricSet)new GarbageCollectorMetricSet());
                metricRegistry.registerAll((MetricSet)new ThreadStatesGaugeSet());
                metricRegistry.registerAll((MetricSet)new MemoryUsageGaugeSet());
            }
        }
    }

    public static class Config {
        public static final Duration DEFAULT_INTERVAL = Duration.ofSeconds(30L);
        private boolean jvmMetrics;
        private Optional<Jmx> jmx = Optional.empty();
        private Optional<Console> console = Optional.empty();
        private Optional<WebSocket> webSocket = Optional.empty();
        private Optional<Csv> csv = Optional.empty();

        public boolean isJvmMetrics() {
            return this.jvmMetrics;
        }

        public Config jvmMetrics(boolean jvmMetrics) {
            this.jvmMetrics = jvmMetrics;
            return this;
        }

        public Optional<Jmx> getJmx() {
            return this.jmx;
        }

        public Config jmx() {
            return this.jmx((Action<? super Jmx>)Action.noop());
        }

        public Config jmx(Action<? super Jmx> configure) {
            try {
                configure.execute((Object)this.jmx.orElseGet(() -> {
                    this.jmx = Optional.of(new Jmx());
                    return this.jmx.get();
                }));
                return this;
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }

        public Optional<Console> getConsole() {
            return this.console;
        }

        public Config console() {
            return this.console((Action<? super Console>)Action.noop());
        }

        public Config console(Action<? super Console> configure) {
            try {
                configure.execute((Object)this.console.orElseGet(() -> {
                    this.console = Optional.of(new Console());
                    return this.console.get();
                }));
                return this;
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }

        public Optional<WebSocket> getWebSocket() {
            return this.webSocket;
        }

        public Config webSocket() {
            return this.webSocket((Action<? super WebSocket>)Action.noop());
        }

        public Config webSocket(Action<? super WebSocket> configure) {
            try {
                configure.execute((Object)this.webSocket.orElseGet(() -> {
                    this.webSocket = Optional.of(new WebSocket());
                    return this.webSocket.get();
                }));
                return this;
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }

        public Optional<Csv> getCsv() {
            return this.csv;
        }

        public Config csv(Action<? super Csv> configure) {
            try {
                configure.execute((Object)this.csv.orElseGet(() -> {
                    this.csv = Optional.of(new Csv());
                    return this.csv.get();
                }));
                return this;
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }

        public static class Csv {
            private Duration reporterInterval = DEFAULT_INTERVAL;
            private File reportDirectory;
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public Csv enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Duration getReporterInterval() {
                return this.reporterInterval;
            }

            public Csv reporterInterval(Duration reporterInterval) {
                this.reporterInterval = reporterInterval;
                return this;
            }

            public File getReportDirectory() {
                return this.reportDirectory;
            }

            public Csv reportDirectory(File reportDirectory) {
                this.reportDirectory = reportDirectory;
                return this;
            }
        }

        public static class WebSocket {
            private Duration reporterInterval = DEFAULT_INTERVAL;

            public Duration getReporterInterval() {
                return this.reporterInterval;
            }

            public WebSocket reporterInterval(Duration reporterInterval) {
                this.reporterInterval = reporterInterval;
                return this;
            }
        }

        public static class Console {
            private Duration reporterInterval = DEFAULT_INTERVAL;
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public Console enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Duration getReporterInterval() {
                return this.reporterInterval;
            }

            public Console reporterInterval(Duration reporterInterval) {
                this.reporterInterval = reporterInterval;
                return this;
            }
        }

        public static class Jmx {
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public Jmx enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }
        }
    }
}

