/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.http.Request;

public class BlockingExecTimingInterceptor
implements ExecInterceptor {
    private final MetricRegistry metricRegistry;
    private final Request request;

    public BlockingExecTimingInterceptor(MetricRegistry metricRegistry, Request request) {
        this.metricRegistry = metricRegistry;
        this.request = request;
    }

    public void intercept(Execution execution, ExecInterceptor.ExecType type, Runnable continuation) {
        if (type == ExecInterceptor.ExecType.BLOCKING) {
            String tag = this.buildBlockingTimerTag(this.request.getUri(), this.request.getMethod().getName());
            Timer.Context timer = this.metricRegistry.timer(tag).time();
            continuation.run();
            timer.stop();
        } else {
            continuation.run();
        }
    }

    private String buildBlockingTimerTag(String requestUri, String requestMethod) {
        return (requestUri.equals("/") ? "[root" : requestUri.replaceFirst("/", "[").replace("/", "][")) + "]~" + requestMethod + "~Blocking";
    }
}

