/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaugeTypeListener
implements TypeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GaugeTypeListener.class);
    @Inject
    MetricRegistry metricRegistry;

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        for (Method method : type.getRawType().getMethods()) {
            com.codahale.metrics.annotation.Gauge annotation = method.getAnnotation(com.codahale.metrics.annotation.Gauge.class);
            if (annotation == null) continue;
            boolean validMethod = true;
            if (method.getParameterTypes().length != 0) {
                validMethod = false;
                encounter.addError("Method %s is annotated with @Gauge but requires parameters.", new Object[]{method});
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                validMethod = false;
                encounter.addError("Method %s is annotated with @Gauge but has a void return type.", new Object[]{method});
            }
            if (!validMethod) continue;
            String gaugeTag = this.buildGaugeTag(method.getAnnotation(com.codahale.metrics.annotation.Gauge.class), method);
            encounter.register(new GaugeInjectionListener(gaugeTag, method));
        }
    }

    private String buildGaugeTag(com.codahale.metrics.annotation.Gauge annotation, Method method) {
        if (annotation.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName()});
        }
        if (annotation.absolute()) {
            return annotation.name();
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{annotation.name()});
    }

    private class GaugeInjectionListener<I>
    implements InjectionListener<I> {
        private final String gaugeTag;
        private final Method method;

        GaugeInjectionListener(String gaugeTag, Method method) {
            this.gaugeTag = gaugeTag;
            this.method = method;
        }

        public void afterInjection(final I injectee) {
            if (!GaugeTypeListener.this.metricRegistry.getMetrics().containsKey(this.gaugeTag)) {
                GaugeTypeListener.this.metricRegistry.register(this.gaugeTag, (Metric)new Gauge<Object>(){

                    public Object getValue() {
                        try {
                            return GaugeInjectionListener.this.method.invoke(injectee, new Object[0]);
                        }
                        catch (Exception e) {
                            return new RuntimeException(e);
                        }
                    }
                });
            } else {
                LOGGER.warn("Cannot register metric gauge, already registered: " + this.gaugeTag);
            }
        }
    }
}

