/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.dropwizard.metrics.GraphiteConfig;
import ratpack.dropwizard.metrics.internal.RegexMetricFilter;

public class GraphiteReporterProvider
implements Provider<GraphiteReporter> {
    private final MetricRegistry metricRegistry;
    private final DropwizardMetricsConfig config;

    @Inject
    public GraphiteReporterProvider(MetricRegistry metricRegistry, DropwizardMetricsConfig config) {
        this.metricRegistry = metricRegistry;
        this.config = config;
    }

    public GraphiteReporter get() {
        Optional<GraphiteConfig> graphite = this.config.getGraphite();
        boolean enabled = graphite.map(GraphiteConfig::isEnabled).orElse(false);
        if (!enabled) {
            return null;
        }
        GraphiteReporter.Builder builder = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry);
        graphite.ifPresent(input -> {
            if (input.getIncludeFilter() != null || input.getExcludeFilter() != null) {
                builder.filter((MetricFilter)new RegexMetricFilter(input.getIncludeFilter(), input.getExcludeFilter()));
            }
            if (input.getPrefix() != null) {
                builder.prefixedWith(input.getPrefix());
            }
            if (input.getDurationUnit() != null) {
                builder.convertDurationsTo(input.getDurationUnit());
            }
            if (input.getRateUnit() != null) {
                builder.convertRatesTo(input.getRateUnit());
            }
        });
        return builder.build(graphite.get().getSender());
    }
}

