/*
 * Decompiled with CFR 0.152.
 */
package ratpack.thymeleaf;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.fragment.WholeFragmentSpec;
import ratpack.thymeleaf.internal.ThymeleafHttpServletRequestAdapter;
import ratpack.thymeleaf.internal.ThymeleafHttpServletResponseAdapter;
import ratpack.thymeleaf.internal.ThymeleafServletContextAdapter;

public class Template {
    private final String name;
    private final WebContext model;
    private final String contentType;
    private final IFragmentSpec fragmentSpec;

    public String getName() {
        return this.name;
    }

    public WebContext getModel() {
        return this.model;
    }

    public String getContentType() {
        return this.contentType;
    }

    public IFragmentSpec getFragmentSpec() {
        return this.fragmentSpec;
    }

    private Template(String name, WebContext model, String contentType, IFragmentSpec fragmentSpec) {
        this.name = name;
        this.model = model;
        this.contentType = contentType;
        this.fragmentSpec = fragmentSpec;
    }

    public static Template thymeleafTemplate(String name) {
        return Template.thymeleafTemplate(Collections.emptyMap(), name);
    }

    public static Template thymeleafTemplate(String name, IFragmentSpec fragmentSpec) {
        return Template.thymeleafTemplate(Collections.emptyMap(), name, fragmentSpec);
    }

    public static Template thymeleafTemplate(Map<String, ?> model, String name) {
        return Template.thymeleafTemplate(model, name, (String)null);
    }

    public static Template thymeleafTemplate(Map<String, ?> model, String name, IFragmentSpec fragmentSpec) {
        return Template.thymeleafTemplate(model, name, null, fragmentSpec);
    }

    public static Template thymeleafTemplate(String name, Consumer<? super ImmutableMap.Builder<String, Object>> modelBuilder) {
        return Template.thymeleafTemplate(name, modelBuilder, (IFragmentSpec)WholeFragmentSpec.INSTANCE);
    }

    public static Template thymeleafTemplate(String name, Consumer<? super ImmutableMap.Builder<String, Object>> modelBuilder, IFragmentSpec fragmentSpec) {
        return Template.thymeleafTemplate(name, null, modelBuilder, fragmentSpec);
    }

    public static Template thymeleafTemplate(String name, String contentType, Consumer<? super ImmutableMap.Builder<String, Object>> modelBuilder) {
        return Template.thymeleafTemplate(name, contentType, modelBuilder, (IFragmentSpec)WholeFragmentSpec.INSTANCE);
    }

    public static Template thymeleafTemplate(String name, String contentType, Consumer<? super ImmutableMap.Builder<String, Object>> modelBuilder, IFragmentSpec fragmentSpec) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        modelBuilder.accept((ImmutableMap.Builder<String, Object>)builder);
        return Template.thymeleafTemplate(builder.build(), name, contentType, fragmentSpec);
    }

    public static Template thymeleafTemplate(Map<String, ?> model, String name, String contentType) {
        return Template.thymeleafTemplate(model, name, contentType, (IFragmentSpec)WholeFragmentSpec.INSTANCE);
    }

    public static Template thymeleafTemplate(Map<String, ?> model, String name, String contentType, IFragmentSpec fragmentSpec) {
        ThymeleafHttpServletRequestAdapter request = new ThymeleafHttpServletRequestAdapter();
        ThymeleafHttpServletResponseAdapter response = new ThymeleafHttpServletResponseAdapter();
        ThymeleafServletContextAdapter servletContext = new ThymeleafServletContextAdapter();
        WebContext context = new WebContext((HttpServletRequest)request, (HttpServletResponse)response, (ServletContext)servletContext);
        if (model != null) {
            context.setVariables(model);
        }
        return new Template(name, context, contentType, fragmentSpec);
    }
}

