/*
 * Decompiled with CFR 0.152.
 */
package ratpack.thymeleaf;

import com.google.common.base.Strings;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.io.File;
import java.util.Set;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.cache.StandardCacheManager;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolver;
import ratpack.guice.ConfigurableModule;
import ratpack.server.ServerConfig;
import ratpack.thymeleaf.internal.FileSystemBindingThymeleafResourceResolver;
import ratpack.thymeleaf.internal.ThymeleafTemplateRenderer;

@Deprecated
public class ThymeleafModule
extends ConfigurableModule<Config> {
    public static final String DEFAULT_TEMPLATE_MODE = "XHTML";
    public static final String DEFAULT_TEMPLATE_PREFIX = "thymeleaf";
    public static final String DEFAULT_TEMPLATE_SUFFIX = ".html";
    private String templatesMode;
    private String templatesPrefix;
    private String templatesSuffix;
    private Integer templatesCacheSize;

    public String getTemplatesMode() {
        return this.templatesMode;
    }

    public void setTemplatesMode(String templatesMode) {
        this.templatesMode = templatesMode;
    }

    public String getTemplatesPrefix() {
        return this.templatesPrefix;
    }

    public void setTemplatesPrefix(String templatesPrefix) {
        this.templatesPrefix = templatesPrefix;
    }

    public String getTemplatesSuffix() {
        return this.templatesSuffix;
    }

    public void setTemplatesSuffix(String templatesSuffix) {
        this.templatesSuffix = templatesSuffix;
    }

    public Integer getTemplatesCacheSize() {
        return this.templatesCacheSize;
    }

    public void setTemplatesCacheSize(Integer templatesCacheSize) {
        this.templatesCacheSize = templatesCacheSize;
    }

    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), IDialect.class);
        this.bind(ThymeleafTemplateRenderer.class).in(Singleton.class);
        this.bind(ICacheManager.class).to(StandardCacheManager.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    ITemplateResolver provideTemplateResolver(ServerConfig serverConfig, Config config) {
        FileSystemBindingThymeleafResourceResolver resourceResolver = new FileSystemBindingThymeleafResourceResolver(serverConfig.getBaseDir());
        TemplateResolver templateResolver = new TemplateResolver();
        templateResolver.setResourceResolver((IResourceResolver)resourceResolver);
        templateResolver.setTemplateMode(this.getTemplatesModeSetting(config));
        templateResolver.setPrefix(this.getTemplatesPrefixSetting(config));
        templateResolver.setSuffix(this.getTemplatesSuffixSetting(config));
        templateResolver.setCacheable(this.getCacheSizeSetting(config) > 0);
        templateResolver.setCacheTTLMs(null);
        return templateResolver;
    }

    @Provides
    @Singleton
    StandardCacheManager provideCacheManager(Config config) {
        int cacheSize = this.getCacheSizeSetting(config);
        StandardCacheManager cacheManager = new StandardCacheManager();
        cacheManager.setTemplateCacheMaxSize(cacheSize);
        return cacheManager;
    }

    @Provides
    @Singleton
    TemplateEngine provideTemplateEngine(ITemplateResolver templateResolver, ICacheManager cacheManager, Set<IDialect> dialects) {
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.setTemplateResolver(templateResolver);
        templateEngine.setCacheManager(cacheManager);
        dialects.stream().forEach(arg_0 -> ((TemplateEngine)templateEngine).addDialect(arg_0));
        return templateEngine;
    }

    private int getCacheSizeSetting(Config config) {
        return this.templatesCacheSize == null ? config.getTemplatesCacheSize() : this.templatesCacheSize.intValue();
    }

    private String getTemplatesModeSetting(Config config) {
        return this.templatesMode == null ? config.getTemplatesMode() : this.templatesMode;
    }

    private String getTemplatesPrefixSetting(Config config) {
        String prefix;
        String string = prefix = this.templatesPrefix == null ? config.getTemplatesPrefix() : this.templatesPrefix;
        if (!prefix.endsWith(File.separator)) {
            prefix = prefix + File.separator;
        }
        return prefix;
    }

    private String getTemplatesSuffixSetting(Config config) {
        String suffix = Strings.emptyToNull((String)(this.templatesSuffix == null ? config.getTemplatesSuffix() : this.templatesSuffix));
        if (suffix == null) {
            suffix = DEFAULT_TEMPLATE_SUFFIX;
        }
        return suffix;
    }

    public static class Config {
        private int templatesCacheSize;
        private String templatesMode = "XHTML";
        private String templatesPrefix = "thymeleaf";
        private String templatesSuffix = ".html";

        public int getTemplatesCacheSize() {
            return this.templatesCacheSize;
        }

        public String getTemplatesMode() {
            return this.templatesMode;
        }

        public String getTemplatesPrefix() {
            return this.templatesPrefix;
        }

        public String getTemplatesSuffix() {
            return this.templatesSuffix;
        }

        public Config templatesCacheSize(int templatesCacheSize) {
            this.templatesCacheSize = templatesCacheSize;
            return this;
        }

        public Config templatesMode(String templatesMode) {
            this.templatesMode = templatesMode;
            return this;
        }

        public Config templatesPrefix(String templatesPrefix) {
            this.templatesPrefix = templatesPrefix;
            return this;
        }

        public Config templateSuffix(String templatesSuffix) {
            this.templatesSuffix = templatesSuffix;
            return this;
        }
    }
}

