/*
 * Decompiled with CFR 0.152.
 */
package ratpack.thymeleaf.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.resourceresolver.IResourceResolver;
import ratpack.file.FileSystemBinding;

public class FileSystemBindingThymeleafResourceResolver
implements IResourceResolver {
    private final FileSystemBinding fileSystemBinding;

    public FileSystemBindingThymeleafResourceResolver(FileSystemBinding fileSystemBinding) {
        this.fileSystemBinding = fileSystemBinding;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public InputStream getResourceAsStream(TemplateProcessingParameters templateProcessingParameters, String resourceName) {
        Path path = this.fileSystemBinding.file(resourceName);
        if (path == null) {
            return null;
        }
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            return null;
        }
    }
}

