/*
 * Decompiled with CFR 0.152.
 */
package ratpack.thymeleaf.internal;

import javax.inject.Inject;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import ratpack.handling.Context;
import ratpack.render.RendererSupport;
import ratpack.thymeleaf.Template;

public class ThymeleafTemplateRenderer
extends RendererSupport<Template> {
    private final TemplateEngine thymeleaf;

    @Inject
    public ThymeleafTemplateRenderer(TemplateEngine thymeleaf) {
        this.thymeleaf = thymeleaf;
    }

    public void render(Context ctx, Template template) {
        String contentType = template.getContentType();
        contentType = contentType == null ? "text/html" : contentType;
        try {
            ctx.getResponse().send((CharSequence)contentType, this.thymeleaf.process(template.getName(), (IContext)template.getModel(), template.getFragmentSpec()));
        }
        catch (Exception e) {
            ctx.error((Throwable)e);
        }
    }
}

