/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.ConstantInfo;
import io.vertx.codegen.Generator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Map;

public class IndexDTS
extends Generator<ClassModel> {
    public IndexDTS() {
        this.incremental = true;
        this.kinds = new HashSet();
        this.kinds.add("class");
        this.name = "es4x-generator (index.d.ts)";
    }

    public String filename(ClassModel model) {
        return "npm/index.d.ts";
    }

    public String render(ClassModel model, int index, int size, Map<String, Object> session) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        ClassTypeInfo type = model.getType();
        if (index == 0) {
            Util.generateLicense(writer);
            if (type.getModuleName().equals("vertx")) {
                writer.print("export interface Handler<T> {\n");
                writer.print("  handle(arg0: T) : void;\n");
                writer.print("}\n\n");
                writer.print("export interface AsyncResult<T> {\n");
                writer.print("  succeeded() : boolean;\n");
                writer.print("  failed() : boolean;\n");
                writer.print("  cause() : Error | null;\n");
                writer.print("  result() : T | null;\n");
                writer.print("}\n\n");
            } else {
                writer.print("import { Handler, AsyncResult } from '@vertx/core';\n\n");
            }
        } else {
            writer.print("\n");
        }
        boolean imports = false;
        for (ApiTypeInfo referencedType : model.getReferencedTypes()) {
            if (Util.isImported((TypeInfo)referencedType, session) || referencedType.getRaw().getModuleName().equals(type.getModuleName())) continue;
            writer.printf("import { %s } from '%s';\n", referencedType.getSimpleName(), Util.getNPMScope(referencedType.getRaw().getModule()));
            imports = true;
        }
        for (ClassTypeInfo dataObjectType : model.getReferencedDataObjectTypes()) {
            if (Util.isImported((TypeInfo)dataObjectType, session)) continue;
            if (dataObjectType.getRaw().getModuleName().equals(type.getModuleName())) {
                writer.printf("import { %s } from './options';\n", dataObjectType.getSimpleName());
                imports = true;
                continue;
            }
            writer.printf("import { %s } from '%s/options';\n", dataObjectType.getSimpleName(), Util.getNPMScope(dataObjectType.getRaw().getModule()));
            imports = true;
        }
        for (EnumTypeInfo enumType : model.getReferencedEnumTypes()) {
            if (Util.isImported((TypeInfo)enumType, session)) continue;
            if (enumType.getRaw().getModuleName().equals(type.getModuleName())) {
                writer.printf("import { %s } from './enums';\n", enumType.getSimpleName());
                imports = true;
                continue;
            }
            writer.printf("import { %s } from '%s/enums';\n", enumType.getSimpleName(), Util.getNPMScope(enumType.getRaw().getModule()));
            imports = true;
        }
        if (imports) {
            writer.print("\n");
        }
        HashSet<String> superTypes = new HashSet<String>();
        model.getAbstractSuperTypes().forEach(ti -> superTypes.add(Util.genType(ti)));
        if (model.getHandlerType() != null && model.isConcrete()) {
            superTypes.add("Handler<" + Util.genType(model.getHandlerType()) + ">");
        }
        writer.printf("export %s %s%s", model.isConcrete() ? "abstract class" : "interface", type.getSimpleName(), Util.genGeneric(type.getParams()));
        if (model.isConcrete()) {
            if (model.getConcreteSuperType() != null) {
                writer.printf(" extends %s", Util.genType(model.getConcreteSuperType()));
            }
            if (!superTypes.isEmpty()) {
                writer.printf(" implements %s", String.join((CharSequence)", ", superTypes));
            }
        } else {
            if (model.getHandlerType() != null) {
                writer.printf(" extends Handler<%s>", Util.genType(model.getHandlerType()));
            }
            if (!superTypes.isEmpty()) {
                writer.printf(" extends %s", String.join((CharSequence)", ", superTypes));
            }
        }
        writer.print(" {\n");
        boolean moreConstants = false;
        if (!model.isConcrete()) {
            for (ConstantInfo constant : model.getConstants()) {
                if (moreConstants) {
                    writer.print("\n");
                }
                if (constant.getDoc() != null) {
                    writer.print("  /**\n");
                    writer.printf("   *%s\n", constant.getDoc().toString().replace("\n", "\n   * "));
                    writer.print("   */\n");
                }
                writer.printf("  static readonly %s : %s;\n", constant.getName(), Util.genType(constant.getType()));
                moreConstants = true;
            }
        }
        boolean moreMethods = false;
        for (MethodInfo method : model.getMethods()) {
            if (moreMethods || moreConstants) {
                writer.print("\n");
            }
            if (method.getDoc() != null) {
                writer.print("  /**\n");
                writer.printf("   *%s\n", method.getDoc().toString().replace("\n", "\n   * "));
                writer.print("   */\n");
            }
            writer.printf("  %s%s%s(", method.isStaticMethod() ? "static " : "", method.getName(), Util.genGeneric(method.getTypeParams()));
            boolean more = false;
            for (ParamInfo param : method.getParams()) {
                if (more) {
                    writer.print(", ");
                }
                writer.printf("%s: %s%s", param.getName(), Util.genType(param.getType()), param.getType().isNullable() ? " | null | undefined" : "");
                more = true;
            }
            writer.printf(") : %s%s;\n", Util.genType(method.getReturnType()), method.getReturnType().isNullable() ? " | null" : "");
            moreMethods = true;
        }
        writer.print("}\n");
        return sw.toString();
    }
}

