/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.codegen.Generator;
import io.vertx.codegen.ModuleModel;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.Map;

public class PackageJSON
extends Generator<ModuleModel> {
    public PackageJSON() {
        this.kinds = new HashSet();
        this.kinds.add("module");
        this.name = "es4x-generator (package.json)";
    }

    public String filename(ModuleModel model) {
        return "npm/package.json";
    }

    public String render(ModuleModel model, int index, int size, Map<String, Object> session) {
        JsonObject json = new JsonObject(System.getProperty("package-json", "{}"));
        if (json.getString("name") == null || json.getString("name").equals("")) {
            json.put("name", Util.getNPMScope(model.getModule()));
        }
        if (!Boolean.getBoolean("npm-meta-package")) {
            json.put("main", "index.js");
            json.put("types", "index.d.ts");
        }
        json.put("sideEffects", Boolean.valueOf(false));
        json.put("version", this.toSemVer(json.getString("version")));
        if (json.containsKey("dependencies")) {
            for (Map.Entry kv : json.getJsonObject("dependencies")) {
                kv.setValue(this.toSemVer((String)kv.getValue()));
            }
        }
        return json.encodePrettily();
    }

    private String toSemVer(String string) {
        char[] version = string.toCharArray();
        int dots = 0;
        for (int i = 0; i < version.length; ++i) {
            if (version[i] != '.' || ++dots <= 2) continue;
            version[i] = 45;
        }
        if (dots > 2) {
            return new String(version);
        }
        return string;
    }
}

