/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public final class Util {
    private static final JsonArray registry = new JsonArray(System.getProperty("scope-registry", "[]"));
    private static final int year = Calendar.getInstance().get(1);

    private Util() {
        throw new RuntimeException("Static Class");
    }

    public static String genType(TypeInfo type) {
        switch (type.getKind()) {
            case STRING: {
                return "string";
            }
            case BOXED_PRIMITIVE: 
            case PRIMITIVE: {
                switch (type.getSimpleName()) {
                    case "boolean": 
                    case "Boolean": {
                        return "boolean";
                    }
                    case "char": 
                    case "Character": {
                        return "string";
                    }
                }
                return "number";
            }
            case ENUM: {
                if (type.getRaw().getModule() != null) {
                    return type.getSimpleName();
                }
                return "any";
            }
            case OBJECT: {
                if (type.isVariable()) {
                    return type.getName();
                }
                return "any";
            }
            case JSON_OBJECT: {
                return "{ [key: string]: any }";
            }
            case JSON_ARRAY: {
                return "any[]";
            }
            case THROWABLE: {
                return "Error";
            }
            case VOID: {
                return "void";
            }
            case LIST: 
            case SET: {
                if (type.isParameterized()) {
                    return Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + "[]";
                }
                return "any[]";
            }
            case MAP: {
                if (type.isParameterized()) {
                    return "{ [key: " + Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + "]: " + Util.genType(((ParameterizedTypeInfo)type).getArg(1)) + "; }";
                }
                return "{ [key: string]: any }";
            }
            case API: {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                if (type.isParameterized()) {
                    for (TypeInfo t : ((ParameterizedTypeInfo)type).getArgs()) {
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append(Util.genType(t));
                        first = false;
                    }
                    return type.getRaw().getSimpleName() + "<" + sb.toString() + ">";
                }
                if (type.getRaw() != null && type.getRaw().getParams().size() > 0) {
                    for (TypeParamInfo t : type.getRaw().getParams()) {
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append("any");
                        first = false;
                    }
                    return type.getSimpleName() + "<" + sb.toString() + ">";
                }
                return type.getErased().getSimpleName();
            }
            case DATA_OBJECT: {
                return type.getErased().getSimpleName();
            }
            case HANDLER: {
                if (type.isParameterized()) {
                    return "(res: " + Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + ") => void | Handler<" + Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + ">";
                }
                return "(res: any) => void | Handler<any>";
            }
            case FUNCTION: {
                if (type.isParameterized()) {
                    return "(arg: " + Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + ") => " + Util.genType(((ParameterizedTypeInfo)type).getArg(1));
                }
                return "(arg: any) => any";
            }
            case ASYNC_RESULT: {
                if (type.isParameterized()) {
                    return "AsyncResult<" + Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + ">";
                }
                return "AsyncResult<any>";
            }
            case CLASS_TYPE: {
                return "any /* TODO: class */";
            }
            case OTHER: {
                return "any /* TODO: other */";
            }
        }
        System.out.println("!!! " + type + " - " + type.getKind());
        return "";
    }

    public static String genGeneric(List<? extends TypeParamInfo> params) {
        StringBuilder sb = new StringBuilder();
        if (params.size() > 0) {
            sb.append("<");
            boolean firstParam = true;
            for (TypeParamInfo typeParamInfo : params) {
                if (!firstParam) {
                    sb.append(", ");
                }
                sb.append(typeParamInfo.getName());
                firstParam = false;
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public static boolean isImported(TypeInfo ref, Map<String, Object> session) {
        if (ref.getRaw().getModuleName() == null) {
            return true;
        }
        String key = ref.getRaw().getModuleName() + "/" + ref.getSimpleName();
        if (!session.containsKey(key)) {
            session.put(key, ref);
            return false;
        }
        return true;
    }

    public static String getNPMScope(ModuleInfo module) {
        String scope = "";
        String name = "";
        for (Object el : registry) {
            JsonObject entry = (JsonObject)el;
            if (!entry.getString("group").equals(module.getGroupPackage())) continue;
            scope = entry.getString("scope", "");
            if (scope.charAt(0) != '@') {
                scope = "@" + scope;
            }
            if (scope.charAt(scope.length() - 1) != '/') {
                scope = scope + "/";
            }
            if (entry.containsKey("prefix") && module.getName().startsWith(entry.getString("prefix"))) {
                name = entry.getBoolean("stripPrefix") != false ? module.getName().substring(entry.getString("prefix").length()) : module.getName();
            }
            if (!entry.containsKey("module") || !module.getName().equals(entry.getString("module"))) continue;
            name = entry.getString("name");
        }
        if (name.equals("")) {
            name = module.getName();
        }
        return scope + name;
    }

    public static String includeFileIfPresent(String file) {
        File path = new File(System.getProperty("basedir"), file);
        if (path.exists()) {
            try {
                byte[] bytes = Files.readAllBytes(path.toPath());
                String md = new String(bytes, StandardCharsets.UTF_8);
                if (md.length() > 0) {
                    if (md.charAt(md.length() - 1) != '\n') {
                        return md + "\n\n";
                    }
                    return md + "\n";
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    public static void generateLicense(PrintWriter writer) {
        writer.println("/*");
        writer.println(" * Copyright " + year + " ES4X");
        writer.println(" *");
        writer.println(" * ES4X licenses this file to you under the Apache License, version 2.0");
        writer.println(" * (the \"License\"); you may not use this file except in compliance with the");
        writer.println(" * License.  You may obtain a copy of the License at:");
        writer.println(" *");
        writer.println(" * http://www.apache.org/licenses/LICENSE-2.0");
        writer.println(" *");
        writer.println(" * Unless required by applicable law or agreed to in writing, software");
        writer.println(" * distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT");
        writer.println(" * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the");
        writer.println(" * License for the specific language governing permissions and limitations");
        writer.println(" * under the License.");
        writer.println(" */");
        writer.println();
    }
}

