/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.Generator;
import io.vertx.codegen.PropertyInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class OptionsDTS
extends Generator<DataObjectModel> {
    public OptionsDTS() {
        this.incremental = true;
        this.kinds = new HashSet();
        this.kinds.add("dataObject");
        this.name = "es4x-generator (options.d.ts)";
    }

    public String filename(DataObjectModel model) {
        return "npm/options.d.ts";
    }

    private Collection<ClassTypeInfo> filterImports(Map<String, PropertyInfo> properties) {
        HashSet<ClassTypeInfo> result = new HashSet<ClassTypeInfo>();
        for (PropertyInfo p : properties.values()) {
            p.getType().collectImports(result);
        }
        return result;
    }

    public String render(DataObjectModel model, int index, int size, Map<String, Object> session) {
        if (Util.isBlacklistedClass(model.getType().getName())) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        boolean imports = false;
        if (index == 0) {
            Util.generateLicense(writer);
        } else {
            writer.print("\n");
        }
        for (ClassTypeInfo referencedType : this.filterImports(model.getPropertyMap())) {
            if (Util.isImported((TypeInfo)referencedType, session)) continue;
            if (referencedType.getKind() == ClassKind.ENUM) {
                if (referencedType.getRaw().getModuleName().equals(model.getType().getRaw().getModuleName())) {
                    writer.printf("import { %s } from './enums';\n", referencedType.getSimpleName());
                    imports = true;
                } else {
                    if (Util.isOptionalModule(Util.getNPMScope(referencedType.getRaw().getModule()))) {
                        writer.println("// @ts-ignore");
                    }
                    writer.printf("import { %s } from '%s/enums';\n", referencedType.getSimpleName(), Util.getNPMScope(referencedType.getRaw().getModule()));
                    imports = true;
                }
            }
            if (referencedType.getKind() == ClassKind.DATA_OBJECT && !referencedType.getRaw().getModuleName().equals(model.getType().getRaw().getModuleName())) {
                if (Util.isOptionalModule(Util.getNPMScope(referencedType.getRaw().getModule()))) {
                    writer.println("// @ts-ignore");
                }
                writer.printf("import { %s } from '%s/options';\n", referencedType.getSimpleName(), Util.getNPMScope(referencedType.getRaw().getModule()));
                imports = true;
            }
            if (referencedType.getKind() != ClassKind.API) continue;
            if (referencedType.getRaw().getModuleName().equals(model.getType().getRaw().getModuleName())) {
                writer.printf("import { %s } from './index';\n", referencedType.getSimpleName());
                imports = true;
                continue;
            }
            if (Util.isOptionalModule(Util.getNPMScope(referencedType.getRaw().getModule()))) {
                writer.println("// @ts-ignore");
            }
            writer.printf("import { %s } from '%s';\n", referencedType.getSimpleName(), Util.getNPMScope(referencedType.getRaw().getModule()));
            imports = true;
        }
        if (imports) {
            writer.print("\n");
        }
        if (model.getDoc() != null) {
            writer.print("/**\n");
            writer.printf(" *%s\n", model.getDoc().toString().replace("\n", "\n * "));
            writer.print("*/\n");
        }
        writer.printf("export %sclass %s {\n", model.isConcrete() ? "" : "abstract ", model.getType().getRaw().getSimpleName());
        writer.print("\n");
        writer.print("  constructor();\n");
        writer.printf("  constructor(obj: %s);\n", model.getType().getRaw().getSimpleName());
        boolean more = false;
        for (Map.Entry entry : model.getPropertyMap().entrySet()) {
            PropertyInfo property = (PropertyInfo)entry.getValue();
            if (more) {
                writer.print("\n");
            }
            if (property.getDoc() != null) {
                writer.print("  /**\n");
                writer.printf("   *%s\n", property.getDoc().toString().replace("\n", "\n   * "));
                writer.print("   */\n");
            }
            String getter = property.getGetterMethod();
            writer.printf("  %s(): %s;\n", getter == null ? entry.getKey() : getter, Util.genType(property.getType()));
            if (property.isSetter()) {
                writer.print("\n");
                if (property.getDoc() != null) {
                    writer.print("  /**\n");
                    writer.printf("   *%s\n", property.getDoc().toString().replace("\n", "\n   * "));
                    writer.print("   */\n");
                }
                writer.printf("  %s(%s: %s): %s;\n", property.getSetterMethod(), Util.cleanReserved((String)entry.getKey()), Util.genType(property.getType()), model.getType().getRaw().getSimpleName());
            }
            if (property.isAdder()) {
                writer.print("\n");
                if (property.getDoc() != null) {
                    writer.print("  /**\n");
                    writer.printf("   *%s\n", property.getDoc().toString().replace("\n", "\n   * "));
                    writer.print("   */\n");
                }
                writer.printf("  %s(%s: %s): %s;\n", property.getAdderMethod(), Util.cleanReserved((String)entry.getKey()), Util.genType(property.getType()), model.getType().getRaw().getSimpleName());
            }
            more = true;
        }
        writer.print("}\n");
        return sw.toString();
    }
}

