/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.codegen.Generator;
import io.vertx.codegen.ModuleModel;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.Map;

public class PackageJSON
extends Generator<ModuleModel> {
    private final String build = System.getenv("PRERELEASE");

    public PackageJSON() {
        this.kinds = new HashSet();
        this.kinds.add("module");
        this.name = "es4x-generator (package.json)";
    }

    public String filename(ModuleModel model) {
        return "npm/package.json";
    }

    public String render(ModuleModel model, int index, int size, Map<String, Object> session) {
        JsonObject json = new JsonObject(System.getProperty("package-json", "{\"version\": \"0.0.0\", \"private\": true, \"name\": \"noname\"}"));
        if (json.getString("name") == null || json.getString("name").equals("")) {
            json.put("name", Util.getNPMScope(model.getModule()));
        }
        if (!Boolean.getBoolean("npm-meta-package")) {
            json.put("main", "index.js");
            json.put("module", "module.mjs");
            json.put("types", "index.d.ts");
        }
        json.put("sideEffects", Boolean.valueOf(false));
        json.put("version", this.toSemVer(json.getString("version")));
        if (json.containsKey("dependencies")) {
            for (Map.Entry kv : json.getJsonObject("dependencies")) {
                kv.setValue(this.toSemVer((String)kv.getValue()));
            }
        }
        if (json.containsKey("devDependencies")) {
            if (json.getJsonObject("devDependencies") != null) {
                JsonObject deps = json.getJsonObject("devDependencies");
                if (deps.size() == 0) {
                    json.remove("devDependencies");
                } else {
                    for (Map.Entry kv : deps) {
                        kv.setValue(this.toSemVer((String)kv.getValue()));
                    }
                }
            } else {
                json.remove("devDependencies");
            }
        }
        return json.encodePrettily();
    }

    private String toSemVer(String string) {
        String base = "0.0.0";
        char[] version = string.toCharArray();
        int dots = 0;
        for (int i = 0; i < version.length && version[i] != '-'; ++i) {
            if (version[i] != '.' || ++dots <= 2) continue;
            version[i] = 45;
        }
        String semver = dots == 2 ? string : (dots > 2 ? new String(version) : base.substring(0, 2 * dots) + new String(version));
        return this.build != null ? semver + "-" + this.build : semver;
    }
}

