/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Util {
    private static final JsonArray REGISTRY;
    private static final int YEAR;
    private static final Map<String, String> TYPES;
    private static final Set<String> RESERVED;
    private static final Map<String, JsonObject> OVERRIDES;
    private static final JsonArray OPTIONAL_DEPENDENCIES;
    private static final JsonArray CLASS_BLACKLIST;

    private Util() {
        throw new RuntimeException("Static Class");
    }

    public static boolean isOptionalModule(String name) {
        return OPTIONAL_DEPENDENCIES.contains((Object)name);
    }

    public static boolean isBlacklistedClass(String name) {
        return CLASS_BLACKLIST.contains((Object)name);
    }

    public static String genType(TypeInfo type) {
        switch (type.getKind()) {
            case STRING: {
                return "string";
            }
            case BOXED_PRIMITIVE: 
            case PRIMITIVE: {
                switch (type.getSimpleName()) {
                    case "boolean": 
                    case "Boolean": {
                        return "boolean";
                    }
                    case "char": 
                    case "Character": {
                        return "string";
                    }
                }
                return "number";
            }
            case ENUM: {
                if (type.getRaw().getModule() != null) {
                    return type.getSimpleName();
                }
                return "any";
            }
            case OBJECT: {
                if (type.isVariable()) {
                    return type.getName();
                }
                return "any";
            }
            case JSON_OBJECT: {
                return "{ [key: string]: any }";
            }
            case JSON_ARRAY: {
                return "any[]";
            }
            case THROWABLE: {
                return "Error";
            }
            case VOID: {
                return "void";
            }
            case LIST: 
            case SET: {
                if (type.isParameterized()) {
                    return Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + "[]";
                }
                return "any[]";
            }
            case MAP: {
                if (type.isParameterized()) {
                    return "{ [key: " + Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + "]: " + Util.genType(((ParameterizedTypeInfo)type).getArg(1)) + "; }";
                }
                return "{ [key: string]: any }";
            }
            case API: {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                if (type.isParameterized()) {
                    for (TypeInfo t : ((ParameterizedTypeInfo)type).getArgs()) {
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append(Util.genType(t));
                        first = false;
                    }
                    if (TYPES.containsKey(type.getRaw().getName())) {
                        return TYPES.get(type.getRaw().getName()) + "<" + sb.toString() + ">";
                    }
                    return type.getRaw().getSimpleName() + "<" + sb.toString() + ">";
                }
                if (type.getRaw() != null && type.getRaw().getParams().size() > 0) {
                    for (TypeParamInfo t : type.getRaw().getParams()) {
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append("any");
                        first = false;
                    }
                    if (TYPES.containsKey(type.getName())) {
                        return TYPES.get(type.getName()) + "<" + sb.toString() + ">";
                    }
                    return type.getSimpleName() + "<" + sb.toString() + ">";
                }
                if (TYPES.containsKey(type.getErased().getName())) {
                    return TYPES.get(type.getErased().getName());
                }
                return type.getErased().getSimpleName();
            }
            case DATA_OBJECT: {
                return type.getErased().getSimpleName();
            }
            case HANDLER: {
                if (type.isParameterized()) {
                    return "((res: " + Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + ") => void) | Handler<" + Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + ">";
                }
                return "((res: any) => void) | Handler<any>";
            }
            case FUNCTION: {
                if (type.isParameterized()) {
                    return "(arg: " + Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + ") => " + Util.genType(((ParameterizedTypeInfo)type).getArg(1));
                }
                return "(arg: any) => any";
            }
            case ASYNC_RESULT: {
                if (type.isParameterized()) {
                    return "AsyncResult<" + Util.genType(((ParameterizedTypeInfo)type).getArg(0)) + ">";
                }
                return "AsyncResult<any>";
            }
            case CLASS_TYPE: {
                return "any /* TODO: class */";
            }
            case OTHER: {
                if (TYPES.containsKey(type.getName())) {
                    return TYPES.get(type.getName());
                }
                System.out.println("@@@ " + type.getName());
                return "any /* " + type.getName() + " */";
            }
        }
        System.out.println("!!! " + type + " - " + type.getKind());
        return "";
    }

    public static String genGeneric(List<? extends TypeParamInfo> params) {
        StringBuilder sb = new StringBuilder();
        if (params.size() > 0) {
            sb.append("<");
            boolean firstParam = true;
            for (TypeParamInfo typeParamInfo : params) {
                if (!firstParam) {
                    sb.append(", ");
                }
                sb.append(typeParamInfo.getName());
                firstParam = false;
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public static boolean isImported(TypeInfo ref, Map<String, Object> session) {
        if (ref.getRaw().getModuleName() == null) {
            return true;
        }
        String key = ref.getRaw().getModuleName() + "/" + ref.getSimpleName();
        if (!session.containsKey(key)) {
            session.put(key, ref);
            return false;
        }
        return true;
    }

    public static String getNPMScope(ModuleInfo module) {
        String scope = "";
        String name = "";
        for (Object el : REGISTRY) {
            JsonObject entry = (JsonObject)el;
            if (!entry.getString("group").equals(module.getGroupPackage())) continue;
            scope = entry.getString("scope", "");
            if (scope.charAt(0) != '@') {
                scope = "@" + scope;
            }
            if (scope.charAt(scope.length() - 1) != '/') {
                scope = scope + "/";
            }
            if (entry.containsKey("prefix") && module.getName().startsWith(entry.getString("prefix"))) {
                name = entry.getBoolean("stripPrefix") != false ? module.getName().substring(entry.getString("prefix").length()) : module.getName();
            }
            if (!entry.containsKey("module") || !module.getName().equals(entry.getString("module"))) continue;
            name = entry.getString("name");
        }
        if (name.equals("")) {
            name = module.getName();
        }
        return scope + name;
    }

    public static String includeFileIfPresent(String file) {
        File path = new File(System.getProperty("basedir"), file);
        if (path.exists()) {
            try {
                byte[] bytes = Files.readAllBytes(path.toPath());
                String md = new String(bytes, StandardCharsets.UTF_8);
                if (md.length() > 0) {
                    if (md.charAt(md.length() - 1) != '\n') {
                        return md + "\n\n";
                    }
                    return md + "\n";
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    public static void generateLicense(PrintWriter writer) {
        writer.println("/*");
        writer.println(" * Copyright " + YEAR + " ES4X");
        writer.println(" *");
        writer.println(" * ES4X licenses this file to you under the Apache License, version 2.0");
        writer.println(" * (the \"License\"); you may not use this file except in compliance with the");
        writer.println(" * License.  You may obtain a copy of the License at:");
        writer.println(" *");
        writer.println(" * http://www.apache.org/licenses/LICENSE-2.0");
        writer.println(" *");
        writer.println(" * Unless required by applicable law or agreed to in writing, software");
        writer.println(" * distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT");
        writer.println(" * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the");
        writer.println(" * License for the specific language governing permissions and limitations");
        writer.println(" * under the License.");
        writer.println(" */");
        writer.println();
    }

    public static String cleanReserved(String value) {
        if (RESERVED.contains(value)) {
            return "__" + value;
        }
        return value;
    }

    private static JsonObject getOverride(String type) {
        JsonObject overrides = OVERRIDES.get(type);
        if (overrides == null) {
            String raw = Util.includeFileIfPresent(type + ".override.json");
            overrides = raw.equals("") ? new JsonObject() : new JsonObject(raw);
            OVERRIDES.put(type, overrides);
        }
        return overrides;
    }

    public static String getOverrideArgs(String type, String method) {
        JsonObject overrides = Util.getOverride(type);
        Object result = overrides.getValue(method);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        return ((JsonObject)result).getString("args");
    }

    public static String getOverrideReturn(String type, String method) {
        JsonObject overrides = Util.getOverride(type);
        Object result = overrides.getValue(method);
        if (result == null) {
            return null;
        }
        if (result instanceof JsonObject) {
            return ((JsonObject)result).getString("return");
        }
        return null;
    }

    static {
        TYPES = new HashMap<String, String>();
        RESERVED = new HashSet<String>();
        OVERRIDES = new HashMap<String, JsonObject>();
        REGISTRY = new JsonArray(System.getProperty("scope-registry", "[]"));
        YEAR = Calendar.getInstance().get(1);
        OPTIONAL_DEPENDENCIES = new JsonArray(System.getProperty("npm-optional-dependencies", "[]"));
        CLASS_BLACKLIST = new JsonArray(System.getProperty("npm-class-blacklist", "[]"));
        TYPES.put("io.vertx.core.Closeable", "(completionHandler: ((res: AsyncResult<void>) => void) | Handler<AsyncResult<void>>) => void");
        TYPES.put("java.lang.CharSequence", "string");
        TYPES.put("java.lang.Iterable<java.lang.String>", "string[]");
        TYPES.put("java.lang.Iterable<java.lang.CharSequence>", "string[]");
        TYPES.put("java.lang.Boolean[]", "boolean[]");
        TYPES.put("java.lang.Double[]", "number[]");
        TYPES.put("java.lang.Float[]", "number[]");
        TYPES.put("java.lang.Integer[]", "number[]");
        TYPES.put("java.lang.Long[]", "number[]");
        TYPES.put("java.lang.Short[]", "number[]");
        TYPES.put("java.lang.String[]", "string[]");
        TYPES.put("java.time.Instant", "Date");
        TYPES.put("java.time.LocalDate", "Date");
        TYPES.put("java.time.LocalDateTime", "Date");
        TYPES.put("java.time.ZonedDateTime", "Date");
        RESERVED.addAll(Arrays.asList("break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "export", "extends", "false", "finally", "for", "function", "if", "import", "in", "instanceof", "new", "null", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with", "as", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"));
    }
}

