/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.contextual.logging;

import io.reactiverse.contextual.logging.ContextualData;
import io.vertx.core.impl.ContextInternal;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.BiFunction;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public final class JULContextualDataFormatter
extends Formatter {
    private static final String placeholderPrefix = "%{";
    private static final String placeholderSuffix = "}";
    private static final String defaultEmpty = "";
    private final String template;
    private final Date dat = new Date();
    private static final List<String> RESERVED = Arrays.asList("date", "source", "logger", "level", "message", "thrown");
    private final List<BiFunction<LogRecord, ContextInternal, Object>> resolvers = new ArrayList<BiFunction<LogRecord, ContextInternal, Object>>();

    public JULContextualDataFormatter() {
        this(LogManager.getLogManager().getProperty(JULContextualDataFormatter.class.getName() + ".format"));
    }

    JULContextualDataFormatter(String template) {
        if (template == null) {
            template = "%1$tb %1$td, %1$tY %1$tl:%1$tM:%1$tS %1$Tp %2$s%n%4$s: %5$s%6$s%n";
        }
        this.resolvers.add((record, ctx) -> {
            this.dat.setTime(record.getMillis());
            return this.dat;
        });
        this.resolvers.add((record, ctx) -> {
            String source;
            if (record.getSourceClassName() != null) {
                source = record.getSourceClassName();
                if (record.getSourceMethodName() != null) {
                    source = source + " " + record.getSourceMethodName();
                }
            } else {
                source = record.getLoggerName();
            }
            return source;
        });
        this.resolvers.add((record, ctx) -> record.getLoggerName());
        this.resolvers.add((record, ctx) -> record.getLevel().getLocalizedName());
        this.resolvers.add((record, ctx) -> this.formatMessage((LogRecord)record));
        this.resolvers.add((record, ctx) -> {
            String throwable = defaultEmpty;
            if (record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                record.getThrown().printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            return throwable;
        });
        this.template = this.parseStringValue(template);
    }

    private String parseStringValue(String template) {
        StringBuilder buf = new StringBuilder(template);
        int startIndex = template.indexOf(placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = JULContextualDataFormatter.findPlaceholderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + placeholderPrefix.length(), endIndex);
                int index = RESERVED.indexOf(placeholder);
                if (index == -1) {
                    String defValue;
                    String ctxKey;
                    int defIndex = placeholder.indexOf(":-");
                    if (defIndex != -1) {
                        ctxKey = placeholder.substring(0, defIndex);
                        defValue = placeholder.substring(defIndex + 2);
                    } else {
                        defValue = defaultEmpty;
                        ctxKey = placeholder;
                    }
                    this.resolvers.add((record, ctx) -> {
                        if (ctx != null) {
                            return ContextualData.getOrDefault(ctxKey, defValue);
                        }
                        return defValue;
                    });
                    index = this.resolvers.size();
                }
                String sIndex = "%" + index;
                buf.replace(startIndex, endIndex + placeholderSuffix.length(), sIndex);
                startIndex = buf.indexOf(placeholderPrefix, startIndex + sIndex.length());
                continue;
            }
            startIndex = -1;
        }
        String format = buf.toString();
        try {
            Object[] args = new Object[this.resolvers.size()];
            args[0] = new Date();
            args[1] = defaultEmpty;
            args[2] = defaultEmpty;
            args[3] = defaultEmpty;
            args[4] = defaultEmpty;
            args[5] = null;
            for (int i = 6; i < args.length; ++i) {
                args[i] = null;
            }
            String.format(format, args);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("format string \"" + template + "\" is not valid.");
        }
        return format;
    }

    private static int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (JULContextualDataFormatter.substringMatch(buf, index, placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index = index + placeholderPrefix.length() - 1;
                    continue;
                }
                return index;
            }
            if (JULContextualDataFormatter.substringMatch(buf, index, placeholderPrefix)) {
                ++withinNestedPlaceholder;
                index += placeholderPrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    private static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String format(LogRecord record) {
        Object[] args = new Object[this.resolvers.size()];
        ContextInternal context = ContextInternal.current();
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.resolvers.get(i).apply(record, context);
        }
        return String.format(this.template, args);
    }
}

