/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.contextual.logging;

import io.reactiverse.contextual.logging.ContextualData;
import io.vertx.core.impl.ContextInternal;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(name="VertxContextualLogging", category="Converter")
@ConverterKeys(value={"vcl"})
public class Log4j2Converter
extends LogEventPatternConverter {
    private String key;
    private String defaultValue = "";

    private Log4j2Converter(String[] options) {
        super(options != null && options.length > 0 ? "vcl{" + options[0] + '}' : "vcl", "vcl");
        if (options != null && options.length > 0) {
            String option = options[0];
            int separator = option.indexOf(":-");
            if (separator == -1) {
                this.key = option;
            } else {
                this.key = option.substring(0, separator);
                this.defaultValue = option.substring(separator + 2);
            }
        }
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        ContextInternal context = ContextInternal.current();
        if (context != null && this.key != null) {
            toAppendTo.append(ContextualData.getOrDefault(this.key, this.defaultValue));
        } else {
            toAppendTo.append(this.defaultValue);
        }
    }

    public static Log4j2Converter newInstance(String[] options) {
        return new Log4j2Converter(options);
    }
}

