/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.contextual.logging;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.OptionHelper;
import io.reactiverse.contextual.logging.ContextualData;
import io.vertx.core.impl.ContextInternal;

public class LogbackConverter
extends ClassicConverter {
    private String key;
    private String defaultValue;

    public LogbackConverter() {
        this.reset();
    }

    private void reset() {
        this.key = null;
        this.defaultValue = "";
    }

    public void start() {
        String[] keyInfo = OptionHelper.extractDefaultReplacement((String)this.getFirstOption());
        this.key = keyInfo[0];
        if (keyInfo[1] != null) {
            this.defaultValue = keyInfo[1];
        }
        super.start();
    }

    public String convert(ILoggingEvent event) {
        ContextInternal context = ContextInternal.current();
        if (context != null && this.key != null) {
            return ContextualData.getOrDefault(this.key, this.defaultValue);
        }
        return this.defaultValue;
    }

    public void stop() {
        this.reset();
        super.stop();
    }
}

