/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.contextual.logging;

import io.reactiverse.contextual.logging.ContextualData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.util.ContextDataProvider;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.TriConsumer;

public class VertxContextDataProvider
implements ContextDataProvider {
    private static final FrozenStringMap EMPTY_FROZEN_STRING_MAP = new FrozenStringMap(Collections.emptyMap());

    public Map<String, String> supplyContextData() {
        Map<String, String> all = ContextualData.getAll();
        if (all != null) {
            return all;
        }
        return Collections.emptyMap();
    }

    public StringMap supplyStringMap() {
        Map<String, String> all = ContextualData.getAll();
        if (all != null && !all.isEmpty()) {
            return new FrozenStringMap(all);
        }
        return EMPTY_FROZEN_STRING_MAP;
    }

    private static class FrozenStringMap
    implements StringMap {
        final Map<String, String> delegate;

        FrozenStringMap(Map<String, String> delegate) {
            this.delegate = delegate;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void freeze() {
        }

        public boolean isFrozen() {
            return true;
        }

        public void putAll(ReadOnlyStringMap source) {
            throw new UnsupportedOperationException();
        }

        public void putValue(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void remove(String key) {
            throw new UnsupportedOperationException();
        }

        public Map<String, String> toMap() {
            return new HashMap<String, String>(this.delegate);
        }

        public boolean containsKey(String key) {
            return this.delegate.containsKey(key);
        }

        public <V> void forEach(BiConsumer<String, ? super V> action) {
            Objects.requireNonNull(action);
            for (Map.Entry<String, String> entry : this.delegate.entrySet()) {
                action.accept((Object)entry.getKey(), (Object)entry.getValue());
            }
        }

        public <V, S> void forEach(TriConsumer<String, ? super V, S> action, S state) {
            Objects.requireNonNull(action);
            for (Map.Entry<String, String> entry : this.delegate.entrySet()) {
                action.accept((Object)entry.getKey(), (Object)entry.getValue(), state);
            }
        }

        public <V> V getValue(String key) {
            return (V)this.delegate.get(key);
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public int size() {
            return this.delegate.size();
        }
    }
}

