/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.contextual.logging.impl;

import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ContextualDataImpl {
    private static final Logger log = LoggerFactory.getLogger(ContextualDataImpl.class);

    public static void put(String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        ContextInternal ctx = ContextInternal.current();
        if (ctx == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Attempt to set contextual data from a non Vert.x thread", (Throwable)new Exception());
            }
        } else {
            ContextualDataImpl.contextualDataMap(ctx).put(key, value);
        }
    }

    public static String get(String key) {
        Objects.requireNonNull(key);
        ContextInternal ctx = ContextInternal.current();
        if (ctx != null) {
            return (String)ContextualDataImpl.contextualDataMap(ctx).get(key);
        }
        return null;
    }

    public static String getOrDefault(String key, String defaultValue) {
        Objects.requireNonNull(key);
        ContextInternal ctx = ContextInternal.current();
        if (ctx != null) {
            return ContextualDataImpl.contextualDataMap(ctx).getOrDefault(key, defaultValue);
        }
        return defaultValue;
    }

    public static Map<String, String> getAll() {
        ContextInternal ctx = ContextInternal.current();
        if (ctx != null) {
            return Collections.unmodifiableMap(new HashMap<String, String>(ContextualDataImpl.contextualDataMap(ctx)));
        }
        return null;
    }

    private static ConcurrentMap<String, String> contextualDataMap(ContextInternal ctx) {
        ConcurrentMap lcd = Objects.requireNonNull(ctx).localContextData();
        return (ConcurrentMap)lcd.computeIfAbsent(ContextualDataImpl.class, k -> new ConcurrentHashMap());
    }
}

