/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.InputStreamDrainer;

public class LinuxPerfProfiler
implements ExternalProfiler {
    private boolean useDelay;

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        long delay = TimeUnit.NANOSECONDS.toMillis((long)params.getWarmup().getCount() * params.getWarmup().getTime().convertTo(TimeUnit.NANOSECONDS) + 1000L);
        if (this.useDelay) {
            return Arrays.asList("perf", "stat", "-d", "-D " + delay);
        }
        return Arrays.asList("perf", "stat", "-d");
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkParams params, File stdOut, File stdErr) {
        PerfResult result = this.process(stdOut, stdErr);
        return Collections.singleton(result);
    }

    @Override
    public Collection<String> checkSupport() {
        Collection<String> delay = this.tryWith("perf stat -D 1 echo 1");
        if (delay.isEmpty()) {
            this.useDelay = true;
            return delay;
        }
        return this.tryWith("perf stat echo 1");
    }

    private Collection<String> tryWith(String cmd) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), baos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), baos);
            errDrainer.start();
            outDrainer.start();
            int err = p.waitFor();
            errDrainer.join();
            outDrainer.join();
            if (err > 0) {
                messages.add(baos.toString());
            }
        }
        catch (IOException ex) {
            return Collections.singleton(ex.getMessage());
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
        return messages;
    }

    @Override
    public String label() {
        return "perf";
    }

    @Override
    public String getDescription() {
        return "Linux perf Statistics";
    }

    private PerfResult process(File stdOut, File stdErr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            String line;
            FileInputStream fis = new FileInputStream(stdErr);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            long cycles = 0L;
            long insns = 0L;
            boolean printing = false;
            while ((line = reader.readLine()) != null) {
                Matcher m;
                if (printing) {
                    pw.println(line);
                }
                if (line.contains("Performance counter stats")) {
                    printing = true;
                }
                if (!(m = Pattern.compile("(.*)#(.*)").matcher(line)).matches()) continue;
                String pair = m.group(1).replace(",", "").trim();
                if (pair.contains(" cycles")) {
                    cycles = Long.valueOf(pair.split("[ ]+")[0]);
                }
                if (!line.contains(" instructions")) continue;
                insns = Long.valueOf(pair.split("[ ]+")[0]);
            }
            pw.flush();
            pw.close();
            return new PerfResult(sw.toString(), cycles, insns);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static class PerfResultAggregator
    implements Aggregator<PerfResult> {
        PerfResultAggregator() {
        }

        @Override
        public Result aggregate(Collection<PerfResult> results) {
            long cycles = 0L;
            long instructions = 0L;
            String output = "";
            for (PerfResult r : results) {
                cycles += r.cycles;
                instructions += r.instructions;
                output = output + r.output;
            }
            return new PerfResult(output, cycles, instructions);
        }
    }

    static class PerfResult
    extends Result<PerfResult> {
        private final String output;
        private final long cycles;
        private final long instructions;

        public PerfResult(String output, long cycles, long instructions) {
            super(ResultRole.SECONDARY, "@cpi", PerfResult.of(1.0 * (double)cycles / (double)instructions), "CPI", AggregationPolicy.AVG);
            this.output = output;
            this.cycles = cycles;
            this.instructions = instructions;
        }

        @Override
        protected Aggregator<PerfResult> getThreadAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Aggregator<PerfResult> getIterationAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        public String toString() {
            return String.format("%.3f cycles per instruction", 1.0 * (double)this.cycles / (double)this.instructions);
        }

        @Override
        public String extendedInfo(String label) {
            return "Perf stats:\n--------------------------------------------------\n" + this.output;
        }
    }
}

