/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmh.runner.Action;
import org.openjdk.jmh.runner.ActionType;

public class ActionPlan
implements Serializable {
    private final List<Action> actions;
    private final ActionType type;

    public ActionPlan(ActionType type) {
        this.type = type;
        this.actions = new ArrayList<Action>();
    }

    public ActionType getType() {
        return this.type;
    }

    public void add(Action action) {
        this.actions.add(action);
    }

    public void mixIn(ActionPlan other) {
        this.actions.addAll(other.actions);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public List<Action> getMeasurementActions() {
        ArrayList<Action> result = new ArrayList<Action>();
        for (Action action : this.actions) {
            switch (action.getMode()) {
                case MEASUREMENT: 
                case WARMUP_MEASUREMENT: {
                    result.add(action);
                }
            }
        }
        return result;
    }
}

