/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import rx.Observable;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;
import rx.internal.util.BackpressureDrainManager;

public class OperatorOnBackpressureBlock<T>
implements Observable.Operator<T, T> {
    final int max;

    public OperatorOnBackpressureBlock(int max) {
        this.max = max;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        BlockingSubscriber<T> s = new BlockingSubscriber<T>(this.max, child);
        s.init();
        return s;
    }

    static final class BlockingSubscriber<T>
    extends Subscriber<T>
    implements BackpressureDrainManager.BackpressureQueueCallback {
        final NotificationLite<T> nl = NotificationLite.instance();
        final BlockingQueue<Object> queue;
        final Subscriber<? super T> child;
        final BackpressureDrainManager manager;

        public BlockingSubscriber(int max, Subscriber<? super T> child) {
            this.queue = new ArrayBlockingQueue<Object>(max);
            this.child = child;
            this.manager = new BackpressureDrainManager(this);
        }

        void init() {
            this.child.add(this);
            this.child.setProducer(this.manager);
        }

        @Override
        public void onNext(T t) {
            block2: {
                try {
                    this.queue.put(this.nl.next(t));
                    this.manager.drain();
                }
                catch (InterruptedException ex) {
                    if (this.isUnsubscribed()) break block2;
                    this.onError(ex);
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            this.manager.terminateAndDrain(e);
        }

        @Override
        public void onCompleted() {
            this.manager.terminateAndDrain();
        }

        @Override
        public boolean accept(Object value) {
            return this.nl.accept(this.child, value);
        }

        @Override
        public void complete(Throwable exception) {
            if (exception != null) {
                this.child.onError(exception);
            } else {
                this.child.onCompleted();
            }
        }

        @Override
        public Object peek() {
            return this.queue.peek();
        }

        @Override
        public Object poll() {
            return this.queue.poll();
        }
    }
}

