/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.internal.operators.BlockingOperatorLatest;
import rx.internal.operators.BlockingOperatorMostRecent;
import rx.internal.operators.BlockingOperatorNext;
import rx.internal.operators.BlockingOperatorToFuture;
import rx.internal.operators.BlockingOperatorToIterator;
import rx.internal.util.UtilityFunctions;

public final class BlockingObservable<T> {
    private final Observable<? extends T> o;

    private BlockingObservable(Observable<? extends T> o) {
        this.o = o;
    }

    public static <T> BlockingObservable<T> from(Observable<? extends T> o) {
        return new BlockingObservable<T>(o);
    }

    public void forEach(final Action1<? super T> onNext2) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference exceptionFromOnError = new AtomicReference();
        Subscription subscription = this.o.subscribe(new Subscriber<T>(){

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onError(Throwable e) {
                exceptionFromOnError.set(e);
                latch.countDown();
            }

            @Override
            public void onNext(T args) {
                onNext2.call(args);
            }
        });
        this.awaitForComplete(latch, subscription);
        if (exceptionFromOnError.get() != null) {
            if (exceptionFromOnError.get() instanceof RuntimeException) {
                throw (RuntimeException)exceptionFromOnError.get();
            }
            throw new RuntimeException((Throwable)exceptionFromOnError.get());
        }
    }

    public Iterator<T> getIterator() {
        return BlockingOperatorToIterator.toIterator(this.o);
    }

    public T first() {
        return this.blockForSingle(this.o.first());
    }

    public T first(Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.first(predicate));
    }

    public T firstOrDefault(T defaultValue) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).firstOrDefault(defaultValue));
    }

    public T firstOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.filter(predicate).map(UtilityFunctions.identity()).firstOrDefault(defaultValue));
    }

    public T last() {
        return this.blockForSingle(this.o.last());
    }

    public T last(Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.last(predicate));
    }

    public T lastOrDefault(T defaultValue) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).lastOrDefault(defaultValue));
    }

    public T lastOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.filter(predicate).map(UtilityFunctions.identity()).lastOrDefault(defaultValue));
    }

    public Iterable<T> mostRecent(T initialValue) {
        return BlockingOperatorMostRecent.mostRecent(this.o, initialValue);
    }

    public Iterable<T> next() {
        return BlockingOperatorNext.next(this.o);
    }

    public Iterable<T> latest() {
        return BlockingOperatorLatest.latest(this.o);
    }

    public T single() {
        return this.blockForSingle(this.o.single());
    }

    public T single(Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.single(predicate));
    }

    public T singleOrDefault(T defaultValue) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).singleOrDefault(defaultValue));
    }

    public T singleOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.filter(predicate).map(UtilityFunctions.identity()).singleOrDefault(defaultValue));
    }

    public Future<T> toFuture() {
        return BlockingOperatorToFuture.toFuture(this.o);
    }

    public Iterable<T> toIterable() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return BlockingObservable.this.getIterator();
            }
        };
    }

    private T blockForSingle(Observable<? extends T> observable2) {
        final AtomicReference returnItem = new AtomicReference();
        final AtomicReference returnException = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Subscription subscription = observable2.subscribe(new Subscriber<T>(){

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onError(Throwable e) {
                returnException.set(e);
                latch.countDown();
            }

            @Override
            public void onNext(T item) {
                returnItem.set(item);
            }
        });
        this.awaitForComplete(latch, subscription);
        if (returnException.get() != null) {
            if (returnException.get() instanceof RuntimeException) {
                throw (RuntimeException)returnException.get();
            }
            throw new RuntimeException((Throwable)returnException.get());
        }
        return (T)returnItem.get();
    }

    private void awaitForComplete(CountDownLatch latch, Subscription subscription) {
        if (latch.getCount() == 0L) {
            return;
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            subscription.unsubscribe();
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for subscription to complete.", e);
        }
    }
}

