/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import rx.Observer;
import rx.Subscriber;
import rx.annotations.Experimental;
import rx.exceptions.OnErrorNotImplementedException;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.observers.Observers;

public final class Subscribers {
    private Subscribers() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Subscriber<T> empty() {
        return Subscribers.from(Observers.empty());
    }

    public static <T> Subscriber<T> from(final Observer<? super T> o) {
        return new Subscriber<T>(){

            @Override
            public void onCompleted() {
                o.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                o.onError(e);
            }

            @Override
            public void onNext(T t) {
                o.onNext(t);
            }
        };
    }

    public static final <T> Subscriber<T> create(final Action1<? super T> onNext2) {
        if (onNext2 == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        return new Subscriber<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                throw new OnErrorNotImplementedException(e);
            }

            @Override
            public final void onNext(T args) {
                onNext2.call(args);
            }
        };
    }

    public static final <T> Subscriber<T> create(final Action1<? super T> onNext2, final Action1<Throwable> onError2) {
        if (onNext2 == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError2 == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        return new Subscriber<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                onError2.call(e);
            }

            @Override
            public final void onNext(T args) {
                onNext2.call(args);
            }
        };
    }

    public static final <T> Subscriber<T> create(final Action1<? super T> onNext2, final Action1<Throwable> onError2, final Action0 onComplete) {
        if (onNext2 == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError2 == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        if (onComplete == null) {
            throw new IllegalArgumentException("onComplete can not be null");
        }
        return new Subscriber<T>(){

            @Override
            public final void onCompleted() {
                onComplete.call();
            }

            @Override
            public final void onError(Throwable e) {
                onError2.call(e);
            }

            @Override
            public final void onNext(T args) {
                onNext2.call(args);
            }
        };
    }

    @Experimental
    public static <T> Subscriber<T> wrap(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){

            @Override
            public void onCompleted() {
                subscriber.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            @Override
            public void onNext(T t) {
                subscriber.onNext(t);
            }
        };
    }
}

