/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.metrics;

import io.reactivex.netty.metrics.ListenerInvocationException;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.metrics.MetricEventsPublisher;
import io.reactivex.netty.metrics.MetricsEvent;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class MetricEventsSubject<E extends MetricsEvent<?>>
implements MetricEventsPublisher<E>,
MetricEventsListener<E> {
    private final CopyOnWriteArrayList<SafeListener<? extends E>> listeners = new CopyOnWriteArrayList();

    @Override
    public void onEvent(E event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        ListenerInvocationException exception = null;
        for (SafeListener<E> listener : this.listeners) {
            try {
                listener.onEvent(event, duration, timeUnit, throwable, value);
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        this.throwIfErrorOccured(exception);
    }

    public void onEvent(E event, long durationInMillis, Throwable throwable, Object value) {
        this.onEvent(event, durationInMillis, TimeUnit.MILLISECONDS, throwable, value);
    }

    public void onEvent(E event) {
        this.onEvent(event, -1L, NO_TIME_UNIT, NO_ERROR, NO_VALUE);
    }

    public void onEvent(E event, Throwable throwable) {
        this.onEvent(event, -1L, NO_TIME_UNIT, throwable, NO_VALUE);
    }

    public void onEvent(E event, long duration, TimeUnit timeUnit) {
        this.onEvent(event, duration, timeUnit, NO_ERROR, NO_VALUE);
    }

    public void onEvent(E event, long duration, TimeUnit timeUnit, Throwable throwable) {
        this.onEvent(event, duration, timeUnit, throwable, NO_VALUE);
    }

    public void onEvent(E event, long duration, TimeUnit timeUnit, Object value) {
        this.onEvent(event, duration, timeUnit, NO_ERROR, value);
    }

    public void onEvent(E event, long durationInMillis) {
        this.onEvent(event, durationInMillis, TimeUnit.MILLISECONDS, NO_ERROR, NO_VALUE);
    }

    public void onEvent(E event, long durationInMillis, Throwable throwable) {
        this.onEvent(event, durationInMillis, TimeUnit.MILLISECONDS, throwable, NO_VALUE);
    }

    public void onEvent(E event, long durationInMillis, Object value) {
        this.onEvent(event, durationInMillis, TimeUnit.MILLISECONDS, NO_ERROR, value);
    }

    public void onEvent(E event, Object value) {
        this.onEvent(event, -1L, NO_TIME_UNIT, NO_ERROR, value);
    }

    @Override
    public void onCompleted() {
        ListenerInvocationException exception = null;
        for (SafeListener<E> listener : this.listeners) {
            try {
                listener.onCompleted();
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        this.throwIfErrorOccured(exception);
    }

    @Override
    public void onSubscribe() {
        ListenerInvocationException exception = null;
        for (SafeListener<E> listener : this.listeners) {
            try {
                listener.onSubscribe();
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        this.throwIfErrorOccured(exception);
    }

    @Override
    public Subscription subscribe(final MetricEventsListener<? extends E> listener) {
        Subscription subscription = Subscriptions.create(new Action0(){

            @Override
            public void call() {
                MetricEventsSubject.this.listeners.remove(listener);
            }
        });
        this.listeners.add(new SafeListener<E>(listener, subscription));
        listener.onSubscribe();
        return subscription;
    }

    protected ListenerInvocationException handleListenerError(ListenerInvocationException exception, SafeListener<? extends E> listener, Throwable e) {
        Exceptions.throwIfFatal(e);
        if (null == exception) {
            exception = new ListenerInvocationException();
        }
        exception.addException(((SafeListener)listener).delegate, e);
        return exception;
    }

    protected void throwIfErrorOccured(ListenerInvocationException exception) {
        if (null != exception) {
            exception.finish();
            throw exception;
        }
    }

    private static class SafeListener<E extends MetricsEvent<?>>
    implements MetricEventsListener<E> {
        private final MetricEventsListener delegate;
        private final Subscription subscription;
        private final AtomicBoolean isDone;

        public SafeListener(MetricEventsListener<? extends E> delegate, Subscription subscription) {
            this.delegate = delegate;
            this.subscription = subscription;
            this.isDone = new AtomicBoolean();
        }

        @Override
        public void onEvent(E event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
            if (!this.isDone.get()) {
                this.delegate.onEvent(event, duration, timeUnit, throwable, value);
            }
        }

        @Override
        public void onCompleted() {
            if (this.isDone.compareAndSet(false, true)) {
                try {
                    this.delegate.onCompleted();
                }
                finally {
                    this.subscription.unsubscribe();
                }
            }
        }

        @Override
        public void onSubscribe() {
            if (!this.isDone.get()) {
                this.delegate.onSubscribe();
            }
        }
    }
}

