/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.infra;

import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.BlackholeL4;
import org.openjdk.jmh.util.Utils;

@State(value=Scope.Thread)
public class Blackhole
extends BlackholeL4 {
    private static volatile long consumedCPU;

    public Blackhole() {
        IllegalStateException iae = new IllegalStateException("Blackholes should not be instantiated directly.");
        for (StackTraceElement el : iae.getStackTrace()) {
            if (!el.getMethodName().startsWith("_jmh_tryInit_") || !el.getClassName().contains("generated")) continue;
            return;
        }
        throw iae;
    }

    @Setup(value=Level.Iteration)
    @TearDown(value=Level.Iteration)
    public void clearSinks() {
        this.obj1 = new Object();
        this.objs1 = new Object[]{new Object()};
    }

    public final void consume(Object obj) {
        this.tlr = this.tlr * 1664525 + 1013904223;
        int tlr = this.tlr;
        if ((tlr & this.tlrMask) == 0) {
            this.obj1 = obj;
            this.tlrMask = (this.tlrMask << 1) + 1;
        }
    }

    public final void consume(Object[] objs) {
        this.tlr = this.tlr * 1664525 + 1013904223;
        int tlr = this.tlr;
        if ((tlr & this.tlrMask) == 0) {
            this.objs1 = objs;
            this.tlrMask = (this.tlrMask << 1) + 1;
        }
    }

    public final void consume(byte b) {
        if (b == this.b1 & b == this.b2) {
            this.nullBait.b1 = b;
        }
    }

    public final void consume(boolean bool) {
        if (bool == this.bool1 & bool == this.bool2) {
            this.nullBait.bool1 = bool;
        }
    }

    public final void consume(char c) {
        if (c == this.c1 & c == this.c2) {
            this.nullBait.c1 = c;
        }
    }

    public final void consume(short s) {
        if (s == this.s1 & s == this.s2) {
            this.nullBait.s1 = s;
        }
    }

    public final void consume(int i) {
        if (i == this.i1 & i == this.i2) {
            this.nullBait.i1 = i;
        }
    }

    public final void consume(long l) {
        if (l == this.l1 & l == this.l2) {
            this.nullBait.l1 = l;
        }
    }

    public final void consume(float f) {
        if (f == this.f1 & f == this.f2) {
            this.nullBait.f1 = f;
        }
    }

    public final void consume(double d) {
        if (d == this.d1 & d == this.d2) {
            this.nullBait.d1 = d;
        }
    }

    public static void consumeCPU(long tokens) {
        long t = consumedCPU;
        for (long i = tokens; i > 0L; --i) {
            t += t * 25214903917L + 11L + i & 0xFFFFFFFFFFFFL;
        }
        if (t == 42L) {
            consumedCPU += t;
        }
    }

    static {
        Utils.check(Blackhole.class, "b1", "b2");
        Utils.check(Blackhole.class, "bool1", "bool2");
        Utils.check(Blackhole.class, "c1", "c2");
        Utils.check(Blackhole.class, "s1", "s2");
        Utils.check(Blackhole.class, "i1", "i2");
        Utils.check(Blackhole.class, "l1", "l2");
        Utils.check(Blackhole.class, "f1", "f2");
        Utils.check(Blackhole.class, "d1", "d2");
        Utils.check(Blackhole.class, "obj1", "objs1");
        consumedCPU = System.nanoTime();
    }
}

